/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.listeners;

import com.chattriggers.ctjs.CTJS;
import com.chattriggers.ctjs.engine.module.Module;
import com.chattriggers.ctjs.engine.module.ModuleManager;
import com.chattriggers.ctjs.minecraft.libs.Tessellator;
import com.chattriggers.ctjs.minecraft.objects.Sound;
import com.chattriggers.ctjs.minecraft.wrappers.World;
import com.chattriggers.ctjs.minecraft.wrappers.entity.PlayerMP;
import com.chattriggers.ctjs.triggers.TriggerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.util.vector.Vector3f;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001dH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/chattriggers/ctjs/minecraft/listeners/WorldListener;", "", "()V", "playerList", "", "", "shouldTriggerWorldLoad", "", "attackEntityEvent", "", "event", "Lnet/minecraftforge/event/entity/player/AttackEntityEvent;", "livingDeathEvent", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "noteBlockEventChange", "Lnet/minecraftforge/event/world/NoteBlockEvent$Change;", "noteBlockEventPlay", "Lnet/minecraftforge/event/world/NoteBlockEvent$Play;", "onRenderGameOverlay", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Pre;", "onRenderWorld", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "onSoundPlay", "Lnet/minecraftforge/client/event/sound/PlaySoundEvent;", "onWorldLoad", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "onWorldUnload", "Lnet/minecraftforge/event/world/WorldEvent$Unload;", "updatePlayerList", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "ctjs"})
public final class WorldListener {
    @NotNull
    public static final WorldListener INSTANCE = new WorldListener();
    private static boolean shouldTriggerWorldLoad;
    @NotNull
    private static List<String> playerList;

    private WorldListener() {
    }

    @SubscribeEvent
    public final void onWorldLoad(@NotNull WorldEvent.Load event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        playerList.clear();
        shouldTriggerWorldLoad = true;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRenderGameOverlay(@NotNull RenderGameOverlayEvent.Pre event) {
        void $this$filterTo$iv$iv;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!shouldTriggerWorldLoad) {
            return;
        }
        TriggerType.WorldLoad.triggerAll(new Object[0]);
        Iterable iterable = ModuleManager.INSTANCE.getPendingOldModules();
        ModuleManager moduleManager = ModuleManager.INSTANCE;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Module p0 = (Module)element$iv;
            boolean bl = false;
            moduleManager.reportOldVersion(p0);
        }
        ModuleManager.INSTANCE.getPendingOldModules().clear();
        shouldTriggerWorldLoad = false;
        Iterable $this$filter$iv = CTJS.INSTANCE.getSounds();
        boolean $i$f$filter = false;
        Iterable $i$f$forEach22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sound it = (Sound)element$iv$iv;
            boolean bl = false;
            if (!it.isListening()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sound it = (Sound)element$iv;
            boolean bl = false;
            it.onWorldLoad();
        }
        CTJS.INSTANCE.getSounds().clear();
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull RenderWorldLastEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Tessellator.setPartialTicks$ctjs(event.partialTicks);
        Object[] objectArray = new Object[]{Float.valueOf(event.partialTicks)};
        TriggerType.RenderWorld.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void onWorldUnload(@NotNull WorldEvent.Unload event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TriggerType.WorldUnload.triggerAll(new Object[0]);
    }

    @SubscribeEvent
    public final void onSoundPlay(@NotNull PlaySoundEvent event) {
        Object[] objectArray;
        Number number;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Vector3f position = new Vector3f(event.sound.func_147649_g(), event.sound.func_147654_h(), event.sound.func_147651_i());
        try {
            number = Float.valueOf(event.sound.func_147653_e());
        }
        catch (Exception ignored) {
            number = 0;
        }
        Number vol = number;
        try {
            objectArray = Float.valueOf(event.sound.func_147655_f());
        }
        catch (Exception ignored) {
            objectArray = 1;
        }
        Number pitch = objectArray;
        objectArray = new Object[6];
        objectArray[0] = position;
        objectArray[1] = event.name;
        objectArray[2] = vol;
        objectArray[3] = pitch;
        Object object = event.category;
        if (object == null) {
            SoundCategory soundCategory = event.category;
            object = soundCategory == null ? null : soundCategory.func_147155_a();
        }
        objectArray[4] = object;
        objectArray[5] = event;
        TriggerType.SoundPlay.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void noteBlockEventPlay(@NotNull NoteBlockEvent.Play event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Vector3f position = new Vector3f((float)event.pos.func_177958_n(), (float)event.pos.func_177956_o(), (float)event.pos.func_177952_p());
        Object[] objectArray = new Object[]{position, event.getNote().name(), event.getOctave(), event};
        TriggerType.NoteBlockPlay.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void noteBlockEventChange(@NotNull NoteBlockEvent.Change event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Vector3f position = new Vector3f((float)event.pos.func_177958_n(), (float)event.pos.func_177956_o(), (float)event.pos.func_177952_p());
        Object[] objectArray = new Object[]{position, event.getNote().name(), event.getOctave(), event};
        TriggerType.NoteBlockChange.triggerAll(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void updatePlayerList(@NotNull TickEvent.ClientTickEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Iterable $this$filter$iv = World.getAllPlayers();
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerMP it = (PlayerMP)element$iv$iv;
            boolean bl = false;
            if (!(!playerList.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerMP it = (PlayerMP)element$iv;
            boolean bl = false;
            playerList.add(it.getName());
            Object[] objectArray2 = new Object[]{it};
            TriggerType.PlayerJoin.triggerAll(objectArray2);
        }
        ListIterator<String> ite = playerList.listIterator();
        while (ite.hasNext()) {
            String it = ite.next();
            if (World.getPlayerByName(it) != null) continue;
            playerList.remove(it);
            objectArray = new Object[]{it};
            TriggerType.PlayerLeave.triggerAll(objectArray);
            break;
        }
    }

    @SubscribeEvent
    public final void livingDeathEvent(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] objectArray = new Object[1];
        Entity entity = event.entity;
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"event.entity");
        objectArray[0] = new com.chattriggers.ctjs.minecraft.wrappers.entity.Entity(entity);
        TriggerType.EntityDeath.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void attackEntityEvent(@NotNull AttackEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] objectArray = new Object[2];
        Entity entity = event.target;
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"event.target");
        objectArray[0] = new com.chattriggers.ctjs.minecraft.wrappers.entity.Entity(entity);
        entity = event.entityPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"event.entityPlayer");
        objectArray[1] = new PlayerMP((EntityPlayer)entity);
        TriggerType.EntityDamage.triggerAll(objectArray);
    }

    static {
        playerList = new ArrayList();
    }
}

