/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.listeners;

import com.chattriggers.ctjs.ReferenceKt;
import com.chattriggers.ctjs.engine.langs.js.JSContextFactory;
import com.chattriggers.ctjs.engine.langs.js.JSLoader;
import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.minecraft.libs.EventLib;
import com.chattriggers.ctjs.minecraft.listeners.CancellableEvent;
import com.chattriggers.ctjs.minecraft.listeners.ClientListener;
import com.chattriggers.ctjs.minecraft.listeners.MouseListener;
import com.chattriggers.ctjs.minecraft.wrappers.Scoreboard;
import com.chattriggers.ctjs.minecraft.wrappers.World;
import com.chattriggers.ctjs.minecraft.wrappers.entity.PlayerMP;
import com.chattriggers.ctjs.minecraft.wrappers.inventory.Item;
import com.chattriggers.ctjs.minecraft.wrappers.world.block.BlockFace;
import com.chattriggers.ctjs.triggers.TriggerType;
import com.chattriggers.ctjs.utils.Config;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.util.vector.Vector3f;
import org.mozilla.javascript.Context;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002<=B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010$\u001a\u00020'H\u0007J\u001a\u0010(\u001a\u00020)2\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010$\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u000202H\u0007J\u0010\u00103\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u000204H\u0007J\u0010\u00105\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u000206H\u0007J\u0010\u00107\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u00108\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u000209H\u0007J\u0010\u0010:\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020;H\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/chattriggers/ctjs/minecraft/listeners/ClientListener;", "", "()V", "actionBarHistory", "", "", "getActionBarHistory", "()Ljava/util/List;", "chatHistory", "getChatHistory", "packetContext", "Lorg/mozilla/javascript/Context;", "tasks", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/chattriggers/ctjs/minecraft/listeners/ClientListener$Task;", "ticksPassed", "", "addTask", "", "delay", "callback", "Lkotlin/Function0;", "handleOverlayTriggers", "event", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Pre;", "onBlockHighlight", "Lnet/minecraftforge/client/event/DrawBlockHighlightEvent;", "onClientDisconnect", "Lnet/minecraftforge/fml/common/network/FMLNetworkEvent$ClientDisconnectionFromServerEvent;", "onDrawScreenEvent", "Lnet/minecraftforge/client/event/GuiScreenEvent$DrawScreenEvent$Post;", "onDropItem", "Lnet/minecraftforge/event/entity/item/ItemTossEvent;", "onGuiOpened", "Lnet/minecraftforge/client/event/GuiOpenEvent;", "onGuiRender", "e", "Lnet/minecraftforge/client/event/GuiScreenEvent$BackgroundDrawnEvent;", "onHandRender", "Lnet/minecraftforge/client/event/RenderHandEvent;", "onHitBlock", "", "pos", "Lnet/minecraft/util/BlockPos;", "Lcom/chattriggers/ctjs/utils/kotlin/MCBlockPos;", "facing", "Lnet/minecraft/util/EnumFacing;", "onInteract", "Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;", "onNetworkEvent", "Lnet/minecraftforge/fml/common/network/FMLNetworkEvent$ClientConnectedToServerEvent;", "onPickupItem", "Lnet/minecraftforge/event/entity/player/EntityItemPickupEvent;", "onReceiveChat", "Lnet/minecraftforge/client/event/ClientChatReceivedEvent;", "onRenderGameOverlay", "onRenderTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$RenderTickEvent;", "onTick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "PlayerInteractAction", "Task", "ctjs"})
public final class ClientListener {
    @NotNull
    public static final ClientListener INSTANCE = new ClientListener();
    private static int ticksPassed;
    @NotNull
    private static final List<String> chatHistory;
    @NotNull
    private static final List<String> actionBarHistory;
    @NotNull
    private static final CopyOnWriteArrayList<Task> tasks;
    @NotNull
    private static Context packetContext;

    private ClientListener() {
    }

    @NotNull
    public final List<String> getChatHistory() {
        return chatHistory;
    }

    @NotNull
    public final List<String> getActionBarHistory() {
        return actionBarHistory;
    }

    @SubscribeEvent
    public final void onReceiveChat(@NotNull ClientChatReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int n = EventLib.getType(event);
        boolean bl = 0 <= n ? n < 2 : false;
        if (bl) {
            ((Collection)chatHistory).add(ChatLib.getChatMessage(event, true));
            if (chatHistory.size() > 1000) {
                chatHistory.remove(0);
            }
            Object[] objectArray = new Object[]{ChatLib.getChatMessage(event, false), event};
            TriggerType.Chat.triggerAll(objectArray);
            if (Config.INSTANCE.getPrintChatToConsole()) {
                ReferenceKt.printToConsole$default(Intrinsics.stringPlus((String)"[CHAT] ", (Object)ChatLib.replaceFormatting(ChatLib.getChatMessage(event, true))), null, null, 3, null);
            }
        } else if (n == 2) {
            ((Collection)actionBarHistory).add(ChatLib.getChatMessage(event, true));
            if (actionBarHistory.size() > 1000) {
                actionBarHistory.remove(0);
            }
            Object[] objectArray = new Object[]{ChatLib.getChatMessage(event, false), event};
            TriggerType.ActionBar.triggerAll(objectArray);
        }
    }

    public final void addTask(int delay, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        tasks.add(new Task(delay, callback));
    }

    @SubscribeEvent
    public final void onTick(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        CollectionsKt.removeAll((List)tasks, (Function1)onTick.1.INSTANCE);
        if (!World.isLoaded()) {
            return;
        }
        Object[] objectArray = new Object[]{ticksPassed};
        TriggerType.Tick.triggerAll(objectArray);
        int n = ticksPassed;
        ticksPassed = n + 1;
        Scoreboard.resetCache();
    }

    @SubscribeEvent
    public final void onClientDisconnect(@NotNull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] objectArray = new Object[]{event};
        TriggerType.ServerDisconnect.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void onNetworkEvent(@NotNull FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] objectArray = new Object[]{event};
        TriggerType.ServerConnect.triggerAll(objectArray);
        event.manager.channel().pipeline().addAfter("fml:packet_handler", "CT_packet_handler", (ChannelHandler)new ChannelDuplexHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void channelRead(@Nullable ChannelHandlerContext ctx, @Nullable Object msg) {
                CancellableEvent packetReceivedEvent = new CancellableEvent();
                if (msg instanceof Packet) {
                    boolean missingContext$iv;
                    JSLoader jSLoader = JSLoader.INSTANCE;
                    Context context$iv = ClientListener.access$getPacketContext$p();
                    boolean $i$f$wrapInContext$ctjs = false;
                    boolean bl = missingContext$iv = Context.getCurrentContext() == null;
                    if (missingContext$iv) {
                        try {
                            JSContextFactory.INSTANCE.enterContext(context$iv);
                        }
                        catch (Throwable e$iv) {
                            JSContextFactory.INSTANCE.enterContext();
                        }
                    }
                    try {
                        boolean bl2 = false;
                        Object[] objectArray = new Object[]{msg, packetReceivedEvent};
                        TriggerType.PacketReceived.triggerAll(objectArray);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        if (missingContext$iv) {
                            Context.exit();
                        }
                    }
                }
                if (!packetReceivedEvent.isCancelled()) {
                    ChannelHandlerContext channelHandlerContext = ctx;
                    if (channelHandlerContext != null) {
                        channelHandlerContext.fireChannelRead(msg);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(@Nullable ChannelHandlerContext ctx, @Nullable Object msg, @Nullable ChannelPromise promise) {
                CancellableEvent packetSentEvent = new CancellableEvent();
                if (msg instanceof Packet) {
                    boolean missingContext$iv;
                    JSLoader jSLoader = JSLoader.INSTANCE;
                    Context context$iv = ClientListener.access$getPacketContext$p();
                    boolean $i$f$wrapInContext$ctjs = false;
                    boolean bl = missingContext$iv = Context.getCurrentContext() == null;
                    if (missingContext$iv) {
                        try {
                            JSContextFactory.INSTANCE.enterContext(context$iv);
                        }
                        catch (Throwable e$iv) {
                            JSContextFactory.INSTANCE.enterContext();
                        }
                    }
                    try {
                        boolean bl2 = false;
                        Object[] objectArray = new Object[]{msg, packetSentEvent};
                        TriggerType.PacketSent.triggerAll(objectArray);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        if (missingContext$iv) {
                            Context.exit();
                        }
                    }
                }
                if (!packetSentEvent.isCancelled()) {
                    ChannelHandlerContext channelHandlerContext = ctx;
                    if (channelHandlerContext != null) {
                        channelHandlerContext.write(msg, promise);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public final void onDrawScreenEvent(@NotNull GuiScreenEvent.DrawScreenEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] objectArray = new Object[]{event.mouseX, event.mouseY, event.gui};
        TriggerType.PostGuiRender.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void onRenderTick(@NotNull TickEvent.RenderTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TriggerType.Step.triggerAll(new Object[0]);
        if (World.isLoaded()) {
            MouseListener.INSTANCE.handleDragged$ctjs();
        }
    }

    @SubscribeEvent
    public final void onRenderGameOverlay(@NotNull RenderGameOverlayEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GlStateManager.func_179094_E();
        this.handleOverlayTriggers(event);
        GlStateManager.func_179121_F();
    }

    private final void handleOverlayTriggers(RenderGameOverlayEvent.Pre event) {
        RenderGameOverlayEvent.ElementType elementType = event.type;
        switch (elementType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[elementType.ordinal()]) {
            case 1: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderPlayerList.triggerAll(objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderCrosshair.triggerAll(objectArray);
                break;
            }
            case 3: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderDebug.triggerAll(objectArray);
                break;
            }
            case 4: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderBossHealth.triggerAll(objectArray);
                break;
            }
            case 5: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderHealth.triggerAll(objectArray);
                break;
            }
            case 6: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderArmor.triggerAll(objectArray);
                break;
            }
            case 7: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderFood.triggerAll(objectArray);
                break;
            }
            case 8: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderMountHealth.triggerAll(objectArray);
                break;
            }
            case 9: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderExperience.triggerAll(objectArray);
                break;
            }
            case 10: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderHotbar.triggerAll(objectArray);
                break;
            }
            case 11: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderAir.triggerAll(objectArray);
                break;
            }
            case 12: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderOverlay.triggerAll(objectArray);
                break;
            }
            case 13: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderPortal.triggerAll(objectArray);
                break;
            }
            case 14: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderJumpBar.triggerAll(objectArray);
                break;
            }
            case 15: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderChat.triggerAll(objectArray);
                break;
            }
            case 16: {
                Object[] objectArray = new Object[]{event};
                TriggerType.RenderHelmet.triggerAll(objectArray);
            }
        }
    }

    @SubscribeEvent
    public final void onGuiOpened(@NotNull GuiOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.gui != null) {
            Object[] objectArray = new Object[]{event};
            TriggerType.GuiOpened.triggerAll(objectArray);
        }
    }

    @SubscribeEvent
    public final void onBlockHighlight(@NotNull DrawBlockHighlightEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.target == null || event.target.func_178782_a() == null) {
            return;
        }
        Vector3f position = new Vector3f((float)event.target.func_178782_a().func_177958_n(), (float)event.target.func_178782_a().func_177956_o(), (float)event.target.func_178782_a().func_177952_p());
        Object[] objectArray = new Object[]{position, event};
        TriggerType.BlockHighlight.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void onPickupItem(@NotNull EntityItemPickupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event.entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayer entityPlayer = event.entityPlayer;
        if (entityPlayer == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayerMP");
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        EntityItem item = event.item;
        Vector3f position = new Vector3f((float)item.field_70165_t, (float)item.field_70163_u, (float)item.field_70161_v);
        Vector3f motion = new Vector3f((float)item.field_70159_w, (float)item.field_70181_x, (float)item.field_70179_y);
        Object[] objectArray = new Object[5];
        ItemStack itemStack = item.func_92059_d();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"item.entityItem");
        objectArray[0] = new Item(itemStack);
        objectArray[1] = new PlayerMP((EntityPlayer)player);
        objectArray[2] = position;
        objectArray[3] = motion;
        objectArray[4] = event;
        TriggerType.PickupItem.triggerAll(objectArray);
    }

    public final boolean onHitBlock(@NotNull BlockPos pos, @NotNull EnumFacing facing) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        CancellableEvent event = new CancellableEvent();
        Object[] objectArray = new Object[]{World.getBlockAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).withFace(BlockFace.Companion.fromMCEnumFacing(facing)), event};
        TriggerType.HitBlock.triggerAll(objectArray);
        return event.isCancelled();
    }

    @SubscribeEvent
    public final void onDropItem(@NotNull ItemTossEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EntityItem item = event.entityItem;
        Vector3f position = new Vector3f((float)item.field_70165_t, (float)item.field_70163_u, (float)item.field_70161_v);
        Vector3f motion = new Vector3f((float)item.field_70159_w, (float)item.field_70181_x, (float)item.field_70179_y);
        Object[] objectArray = new Object[5];
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
        objectArray[0] = new Item(item);
        EntityPlayer entityPlayer = event.player;
        Intrinsics.checkNotNullExpressionValue((Object)entityPlayer, (String)"event.player");
        objectArray[1] = new PlayerMP(entityPlayer);
        objectArray[2] = position;
        objectArray[3] = motion;
        objectArray[4] = event;
        TriggerType.DropItem.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void onGuiRender(@NotNull GuiScreenEvent.BackgroundDrawnEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GlStateManager.func_179094_E();
        Object[] objectArray = new Object[]{e.getMouseX(), e.getMouseY(), e.gui};
        TriggerType.GuiRender.triggerAll(objectArray);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public final void onInteract(@NotNull PlayerInteractEvent e) {
        int n;
        PlayerInteractAction playerInteractAction;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PlayerInteractEvent.Action action = e.action;
        switch (action == null ? -1 : WhenMappings.$EnumSwitchMapping$1[action.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                playerInteractAction = PlayerInteractAction.RIGHT_CLICK_EMPTY;
                break;
            }
            case 3: {
                playerInteractAction = PlayerInteractAction.RIGHT_CLICK_BLOCK;
                break;
            }
            case -1: {
                playerInteractAction = PlayerInteractAction.UNKNOWN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PlayerInteractAction action2 = playerInteractAction;
        Object[] objectArray = new Object[3];
        objectArray[0] = action2;
        BlockPos blockPos = e.pos;
        BlockPos blockPos2 = e.pos;
        float f = blockPos2 == null ? 0 : (n = blockPos2.func_177956_o());
        BlockPos blockPos3 = e.pos;
        objectArray[1] = new Vector3f((float)(blockPos == null ? 0 : (n = blockPos.func_177958_n())), f, (float)(blockPos3 == null ? 0 : (n = blockPos3.func_177952_p())));
        objectArray[2] = e;
        TriggerType.PlayerInteract.triggerAll(objectArray);
    }

    @SubscribeEvent
    public final void onHandRender(@NotNull RenderHandEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object[] objectArray = new Object[]{e};
        TriggerType.RenderHand.triggerAll(objectArray);
    }

    public static final /* synthetic */ Context access$getPacketContext$p() {
        return packetContext;
    }

    static {
        chatHistory = new ArrayList();
        actionBarHistory = new ArrayList();
        tasks = new CopyOnWriteArrayList();
        ticksPassed = 0;
        Context context = JSContextFactory.INSTANCE.enterContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"JSContextFactory.enterContext()");
        packetContext = context;
        Context.exit();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/chattriggers/ctjs/minecraft/listeners/ClientListener$Task;", "", "delay", "", "callback", "Lkotlin/Function0;", "", "(ILkotlin/jvm/functions/Function0;)V", "getCallback", "()Lkotlin/jvm/functions/Function0;", "getDelay", "()I", "setDelay", "(I)V", "ctjs"})
    public static final class Task {
        private int delay;
        @NotNull
        private final Function0<Unit> callback;

        public Task(int delay, @NotNull Function0<Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.delay = delay;
            this.callback = callback;
        }

        public final int getDelay() {
            return this.delay;
        }

        public final void setDelay(int n) {
            this.delay = n;
        }

        @NotNull
        public final Function0<Unit> getCallback() {
            return this.callback;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/chattriggers/ctjs/minecraft/listeners/ClientListener$PlayerInteractAction;", "", "(Ljava/lang/String;I)V", "RIGHT_CLICK_BLOCK", "RIGHT_CLICK_EMPTY", "UNKNOWN", "ctjs"})
    public static final class PlayerInteractAction
    extends Enum<PlayerInteractAction> {
        public static final /* enum */ PlayerInteractAction RIGHT_CLICK_BLOCK = new PlayerInteractAction();
        public static final /* enum */ PlayerInteractAction RIGHT_CLICK_EMPTY = new PlayerInteractAction();
        public static final /* enum */ PlayerInteractAction UNKNOWN = new PlayerInteractAction();
        private static final /* synthetic */ PlayerInteractAction[] $VALUES;

        public static PlayerInteractAction[] values() {
            return (PlayerInteractAction[])$VALUES.clone();
        }

        public static PlayerInteractAction valueOf(String value) {
            return Enum.valueOf(PlayerInteractAction.class, value);
        }

        static {
            $VALUES = playerInteractActionArray = new PlayerInteractAction[]{PlayerInteractAction.RIGHT_CLICK_BLOCK, PlayerInteractAction.RIGHT_CLICK_EMPTY, PlayerInteractAction.UNKNOWN};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RenderGameOverlayEvent.ElementType.values().length];
            nArray[RenderGameOverlayEvent.ElementType.PLAYER_LIST.ordinal()] = 1;
            nArray[RenderGameOverlayEvent.ElementType.CROSSHAIRS.ordinal()] = 2;
            nArray[RenderGameOverlayEvent.ElementType.DEBUG.ordinal()] = 3;
            nArray[RenderGameOverlayEvent.ElementType.BOSSHEALTH.ordinal()] = 4;
            nArray[RenderGameOverlayEvent.ElementType.HEALTH.ordinal()] = 5;
            nArray[RenderGameOverlayEvent.ElementType.ARMOR.ordinal()] = 6;
            nArray[RenderGameOverlayEvent.ElementType.FOOD.ordinal()] = 7;
            nArray[RenderGameOverlayEvent.ElementType.HEALTHMOUNT.ordinal()] = 8;
            nArray[RenderGameOverlayEvent.ElementType.EXPERIENCE.ordinal()] = 9;
            nArray[RenderGameOverlayEvent.ElementType.HOTBAR.ordinal()] = 10;
            nArray[RenderGameOverlayEvent.ElementType.AIR.ordinal()] = 11;
            nArray[RenderGameOverlayEvent.ElementType.TEXT.ordinal()] = 12;
            nArray[RenderGameOverlayEvent.ElementType.PORTAL.ordinal()] = 13;
            nArray[RenderGameOverlayEvent.ElementType.JUMPBAR.ordinal()] = 14;
            nArray[RenderGameOverlayEvent.ElementType.CHAT.ordinal()] = 15;
            nArray[RenderGameOverlayEvent.ElementType.HELMET.ordinal()] = 16;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PlayerInteractEvent.Action.values().length];
            nArray[PlayerInteractEvent.Action.LEFT_CLICK_BLOCK.ordinal()] = 1;
            nArray[PlayerInteractEvent.Action.RIGHT_CLICK_AIR.ordinal()] = 2;
            nArray[PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

