/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.libs.renderer;

import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.minecraft.libs.renderer.Renderer;
import com.chattriggers.ctjs.minecraft.objects.display.DisplayHandler;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0010J\u0006\u0010\u001c\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\u000eJ\u0006\u0010\u001e\u001a\u00020\u0010J\u0006\u0010\u001f\u001a\u00020\u0005J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!J\u0006\u0010\"\u001a\u00020\u0014J\u0006\u0010#\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020\u0005J\u0006\u0010%\u001a\u00020\u0010J\u0006\u0010&\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020\u0005J\u0006\u0010(\u001a\u00020\u0005J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0001J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u00104\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\b\u00105\u001a\u00020\u0003H\u0016J\b\u00106\u001a\u000207H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/chattriggers/ctjs/minecraft/libs/renderer/Text;", "", "string", "", "x", "", "y", "(Ljava/lang/String;FF)V", "config", "Lorg/mozilla/javascript/NativeObject;", "(Ljava/lang/String;Lorg/mozilla/javascript/NativeObject;)V", "align", "Lcom/chattriggers/ctjs/minecraft/objects/display/DisplayHandler$Align;", "color", "", "formatted", "", "lines", "", "maxLines", "", "maxWidth", "scale", "shadow", "width", "draw", "(Ljava/lang/Float;Ljava/lang/Float;)Lcom/chattriggers/ctjs/minecraft/libs/renderer/Text;", "exceedsMaxLines", "getAlign", "getColor", "getFormatted", "getHeight", "getLines", "", "getMaxLines", "getMaxWidth", "getScale", "getShadow", "getString", "getWidth", "getX", "getXAlign", "getY", "setAlign", "setColor", "setFormatted", "setMaxLines", "setMaxWidth", "setScale", "setShadow", "setString", "setX", "setY", "toString", "updateFormatting", "", "ctjs"})
public final class Text {
    private String string;
    private float x;
    private float y;
    @NotNull
    private final List<String> lines;
    private long color;
    private boolean formatted;
    private boolean shadow;
    @NotNull
    private DisplayHandler.Align align;
    private float width;
    private int maxWidth;
    private int maxLines;
    private float scale;

    @JvmOverloads
    public Text(@NotNull String string, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.lines = new ArrayList();
        this.color = 0xFFFFFFFFL;
        this.formatted = true;
        this.align = DisplayHandler.Align.LEFT;
        this.maxLines = Integer.MAX_VALUE;
        this.scale = 1.0f;
        this.setString(string);
        this.setX(x);
        this.setY(y);
    }

    public /* synthetic */ Text(String string, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        if ((n & 4) != 0) {
            f2 = 0.0f;
        }
        this(string, f, f2);
    }

    public Text(@NotNull String string, @NotNull NativeObject config) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.lines = new ArrayList();
        this.color = 0xFFFFFFFFL;
        this.formatted = true;
        this.align = DisplayHandler.Align.LEFT;
        this.maxLines = Integer.MAX_VALUE;
        this.scale = 1.0f;
        this.setString(string);
        this.setColor(Long.parseLong(ExtensionsKt.getOption(config, "color", 0xFFFFFFFFL)));
        this.setFormatted(Boolean.parseBoolean(ExtensionsKt.getOption(config, "formatted", true)));
        this.setShadow(Boolean.parseBoolean(ExtensionsKt.getOption(config, "shadow", false)));
        this.setAlign(ExtensionsKt.getOption(config, "align", (Object)DisplayHandler.Align.LEFT));
        this.setX(Float.parseFloat(ExtensionsKt.getOption(config, "x", Float.valueOf(0.0f))));
        this.setY(Float.parseFloat(ExtensionsKt.getOption(config, "y", Float.valueOf(0.0f))));
        this.setMaxLines((int)Double.parseDouble(ExtensionsKt.getOption(config, "maxLines", Integer.MAX_VALUE)));
        this.setScale(Float.parseFloat(ExtensionsKt.getOption(config, "scale", Float.valueOf(1.0f))));
        this.setMaxWidth(Integer.parseInt(ExtensionsKt.getOption(config, "maxWidth", 0)));
    }

    @NotNull
    public final String getString() {
        String string = this.string;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"string");
            string = null;
        }
        return string;
    }

    @NotNull
    public final Text setString(@NotNull String string) {
        Text text;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Text $this$setString_u24lambda_u2d0 = text = this;
        boolean bl = false;
        $this$setString_u24lambda_u2d0.string = string;
        $this$setString_u24lambda_u2d0.updateFormatting();
        return text;
    }

    public final long getColor() {
        return this.color;
    }

    @NotNull
    public final Text setColor(long color) {
        Text text;
        Text $this$setColor_u24lambda_u2d1 = text = this;
        boolean bl = false;
        $this$setColor_u24lambda_u2d1.color = Renderer.fixAlpha(color);
        return text;
    }

    public final boolean getFormatted() {
        return this.formatted;
    }

    @NotNull
    public final Text setFormatted(boolean formatted) {
        Text text;
        Text $this$setFormatted_u24lambda_u2d2 = text = this;
        boolean bl = false;
        $this$setFormatted_u24lambda_u2d2.formatted = formatted;
        $this$setFormatted_u24lambda_u2d2.updateFormatting();
        return text;
    }

    public final boolean getShadow() {
        return this.shadow;
    }

    @NotNull
    public final Text setShadow(boolean shadow) {
        Text text;
        Text $this$setShadow_u24lambda_u2d3 = text = this;
        boolean bl = false;
        $this$setShadow_u24lambda_u2d3.shadow = shadow;
        return text;
    }

    @NotNull
    public final DisplayHandler.Align getAlign() {
        return this.align;
    }

    @NotNull
    public final Text setAlign(@NotNull Object align) {
        DisplayHandler.Align align2;
        Text text;
        Intrinsics.checkNotNullParameter((Object)align, (String)"align");
        Text $this$setAlign_u24lambda_u2d4 = text = this;
        boolean bl = false;
        Object object = align;
        if (object instanceof String) {
            String string = ((String)align).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            align2 = DisplayHandler.Align.valueOf(string);
        } else {
            align2 = object instanceof DisplayHandler.Align ? (DisplayHandler.Align)((Object)align) : DisplayHandler.Align.LEFT;
        }
        $this$setAlign_u24lambda_u2d4.align = align2;
        return text;
    }

    public final float getX() {
        return this.x;
    }

    @NotNull
    public final Text setX(float x) {
        Text text;
        Text $this$setX_u24lambda_u2d5 = text = this;
        boolean bl = false;
        $this$setX_u24lambda_u2d5.x = x;
        return text;
    }

    public final float getY() {
        return this.y;
    }

    @NotNull
    public final Text setY(float y) {
        Text text;
        Text $this$setY_u24lambda_u2d6 = text = this;
        boolean bl = false;
        $this$setY_u24lambda_u2d6.y = y;
        return text;
    }

    public final float getWidth() {
        return this.width;
    }

    @NotNull
    public final List<String> getLines() {
        return this.lines;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    @NotNull
    public final Text setMaxLines(int maxLines) {
        Text text;
        Text $this$setMaxLines_u24lambda_u2d7 = text = this;
        boolean bl = false;
        $this$setMaxLines_u24lambda_u2d7.maxLines = maxLines;
        return text;
    }

    public final float getScale() {
        return this.scale;
    }

    @NotNull
    public final Text setScale(float scale) {
        Text text;
        Text $this$setScale_u24lambda_u2d8 = text = this;
        boolean bl = false;
        $this$setScale_u24lambda_u2d8.scale = scale;
        return text;
    }

    @NotNull
    public final Text setMaxWidth(int maxWidth) {
        Text text;
        Text $this$setMaxWidth_u24lambda_u2d9 = text = this;
        boolean bl = false;
        $this$setMaxWidth_u24lambda_u2d9.maxWidth = maxWidth;
        $this$setMaxWidth_u24lambda_u2d9.updateFormatting();
        return text;
    }

    public final int getMaxWidth() {
        return this.maxWidth;
    }

    public final float getHeight() {
        return this.lines.size() > 1 ? (float)RangesKt.coerceAtMost((int)this.lines.size(), (int)this.maxLines) * this.scale * (float)10 : this.scale * (float)10;
    }

    public final boolean exceedsMaxLines() {
        return this.lines.size() > this.maxLines;
    }

    @JvmOverloads
    @NotNull
    public final Text draw(@Nullable Float x, @Nullable Float y) {
        int i;
        Text text;
        Text $this$draw_u24lambda_u2d11 = text = this;
        boolean bl = false;
        GlStateManager.func_179147_l();
        GlStateManager.func_179152_a((float)$this$draw_u24lambda_u2d11.scale, (float)$this$draw_u24lambda_u2d11.scale, (float)$this$draw_u24lambda_u2d11.scale);
        Iterator iterator = ((Iterable)$this$draw_u24lambda_u2d11.lines).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        String it = (String)iterator.next();
        boolean bl2 = false;
        float f = (float)Renderer.getStringWidth(it) * $this$draw_u24lambda_u2d11.scale;
        while (iterator.hasNext()) {
            String it22 = (String)iterator.next();
            $i$a$-maxOf-Text$draw$1$longestLine$1 = false;
            float it22 = (float)Renderer.getStringWidth(it22) * $this$draw_u24lambda_u2d11.scale;
            f = Math.max(f, it22);
        }
        float longestLine = f;
        if ($this$draw_u24lambda_u2d11.maxWidth != 0) {
            longestLine = RangesKt.coerceAtMost((float)longestLine, (float)$this$draw_u24lambda_u2d11.maxWidth);
        }
        $this$draw_u24lambda_u2d11.width = longestLine;
        Float f2 = y;
        float yHolder = f2 == null ? $this$draw_u24lambda_u2d11.y : f2.floatValue();
        int n = 0;
        int n2 = $this$draw_u24lambda_u2d11.maxLines;
        while (n < n2 && (i = n++) < $this$draw_u24lambda_u2d11.lines.size()) {
            Float f3 = x;
            Renderer.getFontRenderer().func_175065_a($this$draw_u24lambda_u2d11.lines.get(i), $this$draw_u24lambda_u2d11.getXAlign($this$draw_u24lambda_u2d11.lines.get(i), f3 == null ? $this$draw_u24lambda_u2d11.x : f3.floatValue()), yHolder / $this$draw_u24lambda_u2d11.scale, (int)$this$draw_u24lambda_u2d11.color, $this$draw_u24lambda_u2d11.shadow);
            yHolder += $this$draw_u24lambda_u2d11.scale * (float)10;
        }
        GlStateManager.func_179084_k();
        Renderer.finishDraw();
        return text;
    }

    public static /* synthetic */ Text draw$default(Text text, Float f, Float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = null;
        }
        if ((n & 2) != 0) {
            f2 = null;
        }
        return text.draw(f, f2);
    }

    private final void updateFormatting() {
        String string;
        if (this.formatted) {
            String string2 = this.string;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"string");
                string2 = null;
            }
            string = ChatLib.addColor(string2);
        } else {
            String string3 = this.string;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"string");
                string3 = null;
            }
            string = ChatLib.replaceFormatting(string3);
        }
        this.string = string;
        this.lines.clear();
        String string4 = this.string;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"string");
            string4 = null;
        }
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string4, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (this.maxWidth > 0) {
                List list = Renderer.getFontRenderer().func_78271_c(it, this.maxWidth);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFontRenderer().listFo\u2026ringToWidth(it, maxWidth)");
                this.lines.addAll(list);
                continue;
            }
            this.lines.add(it);
        }
    }

    private final float getXAlign(String string, float x) {
        float f;
        float newX = x / this.scale;
        switch (WhenMappings.$EnumSwitchMapping$0[this.align.ordinal()]) {
            case 1: {
                f = newX - (float)(Renderer.getStringWidth(string) / 2);
                break;
            }
            case 2: {
                f = newX - (float)Renderer.getStringWidth(string);
                break;
            }
            default: {
                f = newX;
            }
        }
        return f;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Text{string=");
        String string = this.string;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"string");
            string = null;
        }
        stringBuilder2.append(string).append(", x=").append(this.x).append(", y=").append(this.y).append(", lines=").append(this.lines).append(", color=").append(this.color).append(", scale=").append(this.scale).append(", formatted=").append(this.formatted).append(", shadow=").append(this.shadow).append(", align=").append((Object)this.align).append(", width=").append(this.width).append(", maxWidth=").append(this.maxWidth).append(", maxLines=");
        stringBuilder.append(this.maxLines).append('}');
        return stringBuilder.toString();
    }

    @JvmOverloads
    public Text(@NotNull String string, float x) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this(string, x, 0.0f, 4, null);
    }

    @JvmOverloads
    public Text(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this(string, 0.0f, 0.0f, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Text draw(@Nullable Float x) {
        return Text.draw$default(this, x, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Text draw() {
        return Text.draw$default(this, null, null, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DisplayHandler.Align.values().length];
            nArray[DisplayHandler.Align.CENTER.ordinal()] = 1;
            nArray[DisplayHandler.Align.RIGHT.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

