/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.libs.renderer;

import com.chattriggers.ctjs.minecraft.libs.renderer.Renderer;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.util.vector.Vector2f;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\bJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J\u001e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ&\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\b\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/chattriggers/ctjs/minecraft/libs/renderer/Shape;", "", "color", "", "(J)V", "area", "", "drawMode", "", "reversedVertexes", "", "Lorg/lwjgl/util/vector/Vector2f;", "vertexes", "addVertex", "x", "y", "clone", "copy", "draw", "getColor", "getDrawMode", "getVertexes", "", "insertVertex", "index", "removeVertex", "setCircle", "radius", "steps", "setColor", "setDrawMode", "setLine", "x1", "y1", "x2", "y2", "thickness", "updateArea", "", "ctjs"})
public final class Shape {
    private long color;
    @NotNull
    private final List<Vector2f> vertexes;
    @NotNull
    private final List<Vector2f> reversedVertexes;
    private int drawMode;
    private float area;

    public Shape(long color) {
        this.color = color;
        this.vertexes = new ArrayList();
        this.reversedVertexes = CollectionsKt.asReversedMutable(this.vertexes);
        this.drawMode = 9;
    }

    @NotNull
    public final Shape copy() {
        return this.clone();
    }

    @NotNull
    public final Shape clone() {
        Shape clone = new Shape(this.color);
        clone.vertexes.addAll((Collection<Vector2f>)this.vertexes);
        clone.setDrawMode(this.drawMode);
        return clone;
    }

    public final long getColor() {
        return this.color;
    }

    @NotNull
    public final Shape setColor(long color) {
        Shape shape;
        Shape $this$setColor_u24lambda_u2d0 = shape = this;
        boolean bl = false;
        $this$setColor_u24lambda_u2d0.color = Renderer.fixAlpha(color);
        return shape;
    }

    public final int getDrawMode() {
        return this.drawMode;
    }

    @NotNull
    public final Shape setDrawMode(int drawMode) {
        Shape shape;
        Shape $this$setDrawMode_u24lambda_u2d1 = shape = this;
        boolean bl = false;
        $this$setDrawMode_u24lambda_u2d1.drawMode = drawMode;
        return shape;
    }

    @NotNull
    public final List<Vector2f> getVertexes() {
        return this.vertexes;
    }

    @NotNull
    public final Shape addVertex(float x, float y) {
        Shape shape;
        Shape $this$addVertex_u24lambda_u2d2 = shape = this;
        boolean bl = false;
        $this$addVertex_u24lambda_u2d2.vertexes.add(new Vector2f(x, y));
        $this$addVertex_u24lambda_u2d2.updateArea();
        return shape;
    }

    @NotNull
    public final Shape insertVertex(int index, float x, float y) {
        Shape shape;
        Shape $this$insertVertex_u24lambda_u2d3 = shape = this;
        boolean bl = false;
        $this$insertVertex_u24lambda_u2d3.vertexes.add(index, new Vector2f(x, y));
        $this$insertVertex_u24lambda_u2d3.updateArea();
        return shape;
    }

    @NotNull
    public final Shape removeVertex(int index) {
        Shape shape;
        Shape $this$removeVertex_u24lambda_u2d4 = shape = this;
        boolean bl = false;
        $this$removeVertex_u24lambda_u2d4.vertexes.remove(index);
        $this$removeVertex_u24lambda_u2d4.updateArea();
        return shape;
    }

    @NotNull
    public final Shape setLine(float x1, float y1, float x2, float y2, float thickness) {
        Shape shape;
        Shape $this$setLine_u24lambda_u2d5 = shape = this;
        boolean bl = false;
        $this$setLine_u24lambda_u2d5.vertexes.clear();
        float f = y2 - y1;
        float f2 = x2 - x1;
        float theta = -((float)Math.atan2(f, f2));
        float i = (float)Math.sin(theta) * (thickness / (float)2);
        float j = (float)Math.cos(theta) * (thickness / (float)2);
        $this$setLine_u24lambda_u2d5.addVertex(x1 + i, y1 + j);
        $this$setLine_u24lambda_u2d5.addVertex(x2 + i, y2 + j);
        $this$setLine_u24lambda_u2d5.addVertex(x2 - i, y2 - j);
        $this$setLine_u24lambda_u2d5.addVertex(x1 - i, y1 - j);
        $this$setLine_u24lambda_u2d5.drawMode = 7;
        return shape;
    }

    @NotNull
    public final Shape setCircle(float x, float y, float radius, int steps) {
        Shape shape;
        Shape $this$setCircle_u24lambda_u2d6 = shape = this;
        boolean bl = false;
        $this$setCircle_u24lambda_u2d6.vertexes.clear();
        double theta = Math.PI * 2 / (double)steps;
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        float xHolder = 0.0f;
        float circleX = 1.0f;
        float circleY = 0.0f;
        int n = 0;
        if (n <= steps) {
            int i;
            do {
                i = n++;
                $this$setCircle_u24lambda_u2d6.addVertex(x, y);
                $this$setCircle_u24lambda_u2d6.addVertex(circleX * radius + x, circleY * radius + y);
                xHolder = circleX;
                circleX = cos * circleX - sin * circleY;
                circleY = sin * xHolder + cos * circleY;
                $this$setCircle_u24lambda_u2d6.addVertex(circleX * radius + x, circleY * radius + y);
            } while (i != steps);
        }
        $this$setCircle_u24lambda_u2d6.drawMode = 5;
        return shape;
    }

    @NotNull
    public final Shape draw() {
        Shape shape;
        Shape $this$draw_u24lambda_u2d9 = shape = this;
        boolean bl = false;
        Tessellator tessellator = Tessellator.func_178181_a();
        Intrinsics.checkNotNullExpressionValue((Object)tessellator, (String)"tessellator");
        WorldRenderer worldRenderer = ExtensionsKt.getRenderer(tessellator);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Renderer.INSTANCE.doColor$ctjs($this$draw_u24lambda_u2d9.color);
        worldRenderer.func_181668_a($this$draw_u24lambda_u2d9.drawMode, DefaultVertexFormats.field_181705_e);
        if ($this$draw_u24lambda_u2d9.area < 0.0f) {
            Iterable $this$forEach$iv = $this$draw_u24lambda_u2d9.vertexes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vector2f it = (Vector2f)element$iv;
                boolean bl2 = false;
                worldRenderer.func_181662_b((double)it.x, (double)it.y, 0.0).func_181675_d();
            }
        } else {
            Iterable $this$forEach$iv = $this$draw_u24lambda_u2d9.reversedVertexes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vector2f it = (Vector2f)element$iv;
                boolean bl3 = false;
                worldRenderer.func_181662_b((double)it.x, (double)it.y, 0.0).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        Renderer.finishDraw();
        return shape;
    }

    private final void updateArea() {
        this.area = 0.0f;
        int n = 0;
        int n2 = this.vertexes.size();
        while (n < n2) {
            int i = n++;
            Vector2f p1 = this.vertexes.get(i);
            Vector2f p2 = this.vertexes.get((i + 1) % this.vertexes.size());
            this.area += p1.x * p2.y - p2.x * p1.y;
        }
        this.area /= (float)2;
    }
}

