/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.libs.renderer;

import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.minecraft.libs.MathLib;
import com.chattriggers.ctjs.minecraft.libs.renderer.CTRenderPlayer;
import com.chattriggers.ctjs.minecraft.libs.renderer.Image;
import com.chattriggers.ctjs.minecraft.wrappers.Client;
import com.chattriggers.ctjs.minecraft.wrappers.Player;
import com.chattriggers.ctjs.minecraft.wrappers.entity.PlayerMP;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b7\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0093\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010K\u001a\u00020L2\u0014\u0010M\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020L0O0NH\u0002\u00a2\u0006\u0002\u0010PJ*\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\u00042\b\b\u0002\u0010U\u001a\u00020\u0004H\u0007J*\u0010V\u001a\u00020W2\u0006\u0010R\u001a\u00020L2\u0006\u0010S\u001a\u00020L2\u0006\u0010T\u001a\u00020L2\b\b\u0002\u0010U\u001a\u00020LH\u0007J\u0015\u0010X\u001a\u00020W2\u0006\u0010Y\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bZJ:\u0010[\u001a\u00020W2\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020L2\u0006\u0010]\u001a\u00020L2\u0006\u0010^\u001a\u00020L2\u0006\u0010_\u001a\u00020<2\b\b\u0002\u0010;\u001a\u00020<H\u0007J0\u0010`\u001a\u00020W2\u0006\u0010a\u001a\u00020b2\u0006\u0010\\\u001a\u00020c2\u0006\u0010]\u001a\u00020c2\u0006\u0010d\u001a\u00020c2\u0006\u0010e\u001a\u00020cH\u0007JB\u0010f\u001a\u00020W2\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010g\u001a\u00020L2\u0006\u0010h\u001a\u00020L2\u0006\u0010i\u001a\u00020L2\u0006\u0010j\u001a\u00020L2\u0006\u0010k\u001a\u00020L2\b\b\u0002\u0010;\u001a\u00020<H\u0007J\\\u0010l\u001a\u00020W2\u0006\u0010m\u001a\u00020\u00012\u0006\u0010\\\u001a\u00020<2\u0006\u0010]\u001a\u00020<2\b\b\u0002\u0010n\u001a\u00020C2\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020C2\b\b\u0002\u0010q\u001a\u00020C2\b\b\u0002\u0010r\u001a\u00020C2\b\b\u0002\u0010s\u001a\u00020CH\u0007J0\u0010t\u001a\u00020W2\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020L2\u0006\u0010]\u001a\u00020L2\u0006\u0010d\u001a\u00020L2\u0006\u0010e\u001a\u00020LH\u0007J?\u0010u\u001a\u00020W2\u0006\u0010Q\u001a\u00020\u00042\u001e\u0010v\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020L0O0N\"\b\u0012\u0004\u0012\u00020L0O2\b\b\u0002\u0010;\u001a\u00020<H\u0007\u00a2\u0006\u0002\u0010wJ*\u0010x\u001a\u00020W2\u0006\u0010y\u001a\u00020z2\u0006\u0010\\\u001a\u00020L2\u0006\u0010]\u001a\u00020L2\b\b\u0002\u0010{\u001a\u00020CH\u0007J \u0010|\u001a\u00020W2\u0006\u0010y\u001a\u00020z2\u0006\u0010\\\u001a\u00020L2\u0006\u0010]\u001a\u00020LH\u0007J\b\u0010}\u001a\u00020WH\u0007J\u0010\u0010~\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u0004H\u0007J\u0010\u0010\u007f\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020<H\u0007J\u0011\u0010\u0080\u0001\u001a\u0004\u0018\u00010<H\u0007\u00a2\u0006\u0003\u0010\u0081\u0001J\n\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0007J\u001d\u0010\u0084\u0001\u001a\u00020\u00042\u0007\u0010\u0085\u0001\u001a\u00020L2\t\b\u0002\u0010\u0086\u0001\u001a\u00020LH\u0007J\u001e\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u0085\u0001\u001a\u00020L2\t\b\u0002\u0010\u0086\u0001\u001a\u00020LH\u0007J\t\u0010\u0089\u0001\u001a\u00020AH\u0007J\u0011\u0010\u008a\u0001\u001a\u00020<2\u0006\u0010y\u001a\u00020zH\u0007J\u0011\u0010B\u001a\u00020W2\u0007\u0010\u008b\u0001\u001a\u00020CH\u0007J\u0011\u0010n\u001a\u00020W2\u0007\u0010\u008c\u0001\u001a\u00020LH\u0007J\u001d\u0010\u008d\u0001\u001a\u00020W2\u0007\u0010\u008e\u0001\u001a\u00020L2\t\b\u0002\u0010\u008f\u0001\u001a\u00020LH\u0007J\u0011\u0010\u0090\u0001\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<H\u0007J$\u0010\u0091\u0001\u001a\u00020W2\u0006\u0010\\\u001a\u00020L2\u0006\u0010]\u001a\u00020L2\t\b\u0002\u0010\u0092\u0001\u001a\u00020LH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\u001c\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007R\u001c\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0007R\u001c\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0007R\u001c\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u0007R\u001c\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0007R\u001c\u0010\u001d\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0007R\u001c\u0010 \u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010\u0007R\u001c\u0010#\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\u0002\u001a\u0004\b%\u0010\u0007R\u001c\u0010&\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b'\u0010\u0002\u001a\u0004\b(\u0010\u0007R\u001c\u0010)\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b*\u0010\u0002\u001a\u0004\b+\u0010\u0007R\u001c\u0010,\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b-\u0010\u0002\u001a\u0004\b.\u0010\u0007R\u001c\u0010/\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0002\u001a\u0004\b1\u0010\u0007R\u001c\u00102\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u0002\u001a\u0004\b4\u0010\u0007R\u001e\u00105\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010:\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0012\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010=R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010E\u001a\n G*\u0004\u0018\u00010F0FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010H\u001a\u00060Ij\u0002`JX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0094\u0001"}, d2={"Lcom/chattriggers/ctjs/minecraft/libs/renderer/Renderer;", "", "()V", "AQUA", "", "getAQUA$annotations", "getAQUA", "()J", "BLACK", "getBLACK$annotations", "getBLACK", "BLUE", "getBLUE$annotations", "getBLUE", "DARK_AQUA", "getDARK_AQUA$annotations", "getDARK_AQUA", "DARK_BLUE", "getDARK_BLUE$annotations", "getDARK_BLUE", "DARK_GRAY", "getDARK_GRAY$annotations", "getDARK_GRAY", "DARK_GREEN", "getDARK_GREEN$annotations", "getDARK_GREEN", "DARK_PURPLE", "getDARK_PURPLE$annotations", "getDARK_PURPLE", "DARK_RED", "getDARK_RED$annotations", "getDARK_RED", "GOLD", "getGOLD$annotations", "getGOLD", "GRAY", "getGRAY$annotations", "getGRAY", "GREEN", "getGREEN$annotations", "getGREEN", "LIGHT_PURPLE", "getLIGHT_PURPLE$annotations", "getLIGHT_PURPLE", "RED", "getRED$annotations", "getRED", "WHITE", "getWHITE$annotations", "getWHITE", "YELLOW", "getYELLOW$annotations", "getYELLOW", "colorized", "getColorized", "()Ljava/lang/Long;", "setColorized", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "drawMode", "", "Ljava/lang/Integer;", "normalCTRenderPlayer", "Lcom/chattriggers/ctjs/minecraft/libs/renderer/CTRenderPlayer;", "renderManager", "Lnet/minecraft/client/renderer/entity/RenderManager;", "retainTransforms", "", "slimCTRenderPlayer", "tessellator", "Lnet/minecraft/client/renderer/Tessellator;", "kotlin.jvm.PlatformType", "worldRenderer", "Lnet/minecraft/client/renderer/WorldRenderer;", "Lcom/chattriggers/ctjs/utils/kotlin/MCWorldRenderer;", "area", "", "points", "", "", "([Ljava/util/List;)F", "color", "red", "green", "blue", "alpha", "colorize", "", "doColor", "longColor", "doColor$ctjs", "drawCircle", "x", "y", "radius", "steps", "drawImage", "image", "Lcom/chattriggers/ctjs/minecraft/libs/renderer/Image;", "", "width", "height", "drawLine", "x1", "y1", "x2", "y2", "thickness", "drawPlayer", "player", "rotate", "showNametag", "showArmor", "showCape", "showHeldItem", "showArrows", "drawRect", "drawShape", "vertexes", "(J[Ljava/util/List;I)V", "drawString", "text", "", "shadow", "drawStringWithShadow", "finishDraw", "fixAlpha", "getColor", "getDrawMode", "()Ljava/lang/Integer;", "getFontRenderer", "Lnet/minecraft/client/gui/FontRenderer;", "getRainbow", "step", "speed", "getRainbowColors", "", "getRenderManager", "getStringWidth", "retain", "angle", "scale", "scaleX", "scaleY", "setDrawMode", "translate", "z", "screen", "ctjs"})
public final class Renderer {
    @NotNull
    public static final Renderer INSTANCE = new Renderer();
    @Nullable
    private static Long colorized;
    private static boolean retainTransforms;
    @Nullable
    private static Integer drawMode;
    private static final Tessellator tessellator;
    @NotNull
    private static final WorldRenderer worldRenderer;
    private static final long BLACK;
    private static final long DARK_BLUE;
    private static final long DARK_GREEN;
    private static final long DARK_AQUA;
    private static final long DARK_RED;
    private static final long DARK_PURPLE;
    private static final long GOLD;
    private static final long GRAY;
    private static final long DARK_GRAY;
    private static final long BLUE;
    private static final long GREEN;
    private static final long AQUA;
    private static final long RED;
    private static final long LIGHT_PURPLE;
    private static final long YELLOW;
    private static final long WHITE;
    @NotNull
    private static final RenderManager renderManager;
    @NotNull
    private static final CTRenderPlayer slimCTRenderPlayer;
    @NotNull
    private static final CTRenderPlayer normalCTRenderPlayer;

    private Renderer() {
    }

    @Nullable
    public final Long getColorized() {
        return colorized;
    }

    public final void setColorized(@Nullable Long l) {
        colorized = l;
    }

    public static final long getBLACK() {
        return BLACK;
    }

    @JvmStatic
    public static /* synthetic */ void getBLACK$annotations() {
    }

    public static final long getDARK_BLUE() {
        return DARK_BLUE;
    }

    @JvmStatic
    public static /* synthetic */ void getDARK_BLUE$annotations() {
    }

    public static final long getDARK_GREEN() {
        return DARK_GREEN;
    }

    @JvmStatic
    public static /* synthetic */ void getDARK_GREEN$annotations() {
    }

    public static final long getDARK_AQUA() {
        return DARK_AQUA;
    }

    @JvmStatic
    public static /* synthetic */ void getDARK_AQUA$annotations() {
    }

    public static final long getDARK_RED() {
        return DARK_RED;
    }

    @JvmStatic
    public static /* synthetic */ void getDARK_RED$annotations() {
    }

    public static final long getDARK_PURPLE() {
        return DARK_PURPLE;
    }

    @JvmStatic
    public static /* synthetic */ void getDARK_PURPLE$annotations() {
    }

    public static final long getGOLD() {
        return GOLD;
    }

    @JvmStatic
    public static /* synthetic */ void getGOLD$annotations() {
    }

    public static final long getGRAY() {
        return GRAY;
    }

    @JvmStatic
    public static /* synthetic */ void getGRAY$annotations() {
    }

    public static final long getDARK_GRAY() {
        return DARK_GRAY;
    }

    @JvmStatic
    public static /* synthetic */ void getDARK_GRAY$annotations() {
    }

    public static final long getBLUE() {
        return BLUE;
    }

    @JvmStatic
    public static /* synthetic */ void getBLUE$annotations() {
    }

    public static final long getGREEN() {
        return GREEN;
    }

    @JvmStatic
    public static /* synthetic */ void getGREEN$annotations() {
    }

    public static final long getAQUA() {
        return AQUA;
    }

    @JvmStatic
    public static /* synthetic */ void getAQUA$annotations() {
    }

    public static final long getRED() {
        return RED;
    }

    @JvmStatic
    public static /* synthetic */ void getRED$annotations() {
    }

    public static final long getLIGHT_PURPLE() {
        return LIGHT_PURPLE;
    }

    @JvmStatic
    public static /* synthetic */ void getLIGHT_PURPLE$annotations() {
    }

    public static final long getYELLOW() {
        return YELLOW;
    }

    @JvmStatic
    public static /* synthetic */ void getYELLOW$annotations() {
    }

    public static final long getWHITE() {
        return WHITE;
    }

    @JvmStatic
    public static /* synthetic */ void getWHITE$annotations() {
    }

    @JvmStatic
    public static final long getColor(int color) {
        long l;
        switch (color) {
            case 0: {
                l = BLACK;
                break;
            }
            case 1: {
                l = DARK_BLUE;
                break;
            }
            case 2: {
                l = DARK_GREEN;
                break;
            }
            case 3: {
                l = DARK_AQUA;
                break;
            }
            case 4: {
                l = DARK_RED;
                break;
            }
            case 5: {
                l = DARK_PURPLE;
                break;
            }
            case 6: {
                l = GOLD;
                break;
            }
            case 7: {
                l = GRAY;
                break;
            }
            case 8: {
                l = DARK_GRAY;
                break;
            }
            case 9: {
                l = BLUE;
                break;
            }
            case 10: {
                l = GREEN;
                break;
            }
            case 11: {
                l = AQUA;
                break;
            }
            case 12: {
                l = RED;
                break;
            }
            case 13: {
                l = LIGHT_PURPLE;
                break;
            }
            case 14: {
                l = YELLOW;
                break;
            }
            default: {
                l = WHITE;
            }
        }
        return l;
    }

    @JvmStatic
    @NotNull
    public static final FontRenderer getFontRenderer() {
        FontRenderer fontRenderer = Client.Companion.getMinecraft().field_71466_p;
        Intrinsics.checkNotNullExpressionValue((Object)fontRenderer, (String)"Client.getMinecraft().fontRendererObj");
        return fontRenderer;
    }

    @JvmStatic
    @NotNull
    public static final RenderManager getRenderManager() {
        RenderManager renderManager = Client.Companion.getMinecraft().func_175598_ae();
        Intrinsics.checkNotNullExpressionValue((Object)renderManager, (String)"Client.getMinecraft().renderManager");
        return renderManager;
    }

    @JvmStatic
    public static final int getStringWidth(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return INSTANCE.getFontRenderer().func_78256_a(ChatLib.addColor(text));
    }

    @JvmStatic
    @JvmOverloads
    public static final long color(long red, long green, long blue, long alpha) {
        return MathLib.clamp((int)alpha, 0, 255) * 0x1000000 + MathLib.clamp((int)red, 0, 255) * 65536 + MathLib.clamp((int)green, 0, 255) * 256 + MathLib.clamp((int)blue, 0, 255);
    }

    public static /* synthetic */ long color$default(long l, long l2, long l3, long l4, int n, Object object) {
        if ((n & 8) != 0) {
            l4 = 255L;
        }
        return Renderer.color(l, l2, l3, l4);
    }

    @JvmStatic
    @JvmOverloads
    public static final long getRainbow(float step, float speed) {
        long red = (long)(((double)((float)Math.sin(step / speed)) + 0.75) * (double)170);
        long green = (long)((Math.sin((double)(step / speed) + 2.0943951023931953) + 0.75) * (double)170);
        long blue = (long)((Math.sin((double)(step / speed) + 4.1887902047863905) + 0.75) * (double)170);
        return Renderer.color(red, green, blue, 255L);
    }

    public static /* synthetic */ long getRainbow$default(float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        return Renderer.getRainbow(f, f2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final int[] getRainbowColors(float step, float speed) {
        int red = (int)(((double)((float)Math.sin(step / speed)) + 0.75) * (double)170);
        int green = (int)((Math.sin((double)(step / speed) + 2.0943951023931953) + 0.75) * (double)170);
        int blue = (int)((Math.sin((double)(step / speed) + 4.1887902047863905) + 0.75) * (double)170);
        int[] nArray = new int[]{red, green, blue};
        return nArray;
    }

    public static /* synthetic */ int[] getRainbowColors$default(float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        return Renderer.getRainbowColors(f, f2);
    }

    @JvmStatic
    public static final void retainTransforms(boolean retain) {
        retainTransforms = retain;
        INSTANCE.finishDraw();
    }

    @JvmStatic
    @JvmOverloads
    public static final void translate(float x, float y, float z) {
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
    }

    public static /* synthetic */ void translate$default(float f, float f2, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        Renderer.translate(f, f2, f3);
    }

    @JvmStatic
    @JvmOverloads
    public static final void scale(float scaleX, float scaleY) {
        GlStateManager.func_179152_a((float)scaleX, (float)scaleY, (float)1.0f);
    }

    public static /* synthetic */ void scale$default(float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        Renderer.scale(f, f2);
    }

    @JvmStatic
    public static final void rotate(float angle) {
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    @JvmStatic
    @JvmOverloads
    public static final void colorize(float red, float green, float blue, float alpha) {
        colorized = Renderer.fixAlpha(Renderer.color((long)red, (long)green, (long)blue, (long)alpha));
        GlStateManager.func_179131_c((float)MathLib.clampFloat(red, 0.0f, 1.0f), (float)MathLib.clampFloat(green, 0.0f, 1.0f), (float)MathLib.clampFloat(blue, 0.0f, 1.0f), (float)MathLib.clampFloat(alpha, 0.0f, 1.0f));
    }

    public static /* synthetic */ void colorize$default(float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        Renderer.colorize(f, f2, f3, f4);
    }

    @JvmStatic
    @NotNull
    public static final Renderer setDrawMode(int drawMode) {
        Renderer renderer;
        Renderer $this$setDrawMode_u24lambda_u2d0 = renderer = INSTANCE;
        boolean bl = false;
        Renderer.drawMode = drawMode;
        return renderer;
    }

    @JvmStatic
    @Nullable
    public static final Integer getDrawMode() {
        return drawMode;
    }

    @JvmStatic
    public static final long fixAlpha(long color) {
        long alpha = color >> 24 & 0xFFL;
        return alpha < 10L ? color & 0xFFFFFFL | 0xAFFFFFFL : color;
    }

    @JvmStatic
    public static final void drawRect(long color, float x, float y, float width, float height) {
        Object[] objectArray = new Float[]{Float.valueOf(x), Float.valueOf(y), Float.valueOf(x + width), Float.valueOf(y + height)};
        List pos = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((Number)pos.get(0)).floatValue() > ((Number)pos.get(2)).floatValue()) {
            Collections.swap(pos, 0, 2);
        }
        if (((Number)pos.get(1)).floatValue() > ((Number)pos.get(3)).floatValue()) {
            Collections.swap(pos, 1, 3);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        INSTANCE.doColor$ctjs(color);
        Integer n = drawMode;
        worldRenderer.func_181668_a(n == null ? 7 : n, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)((Number)pos.get(0)).floatValue(), (double)((Number)pos.get(3)).floatValue(), 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)((Number)pos.get(2)).floatValue(), (double)((Number)pos.get(3)).floatValue(), 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)((Number)pos.get(2)).floatValue(), (double)((Number)pos.get(1)).floatValue(), 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)((Number)pos.get(0)).floatValue(), (double)((Number)pos.get(1)).floatValue(), 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        INSTANCE.finishDraw();
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawShape(long color, @NotNull List<Float>[] vertexes, int drawMode) {
        Intrinsics.checkNotNullParameter(vertexes, (String)"vertexes");
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        INSTANCE.doColor$ctjs(color);
        Integer n = Renderer.drawMode;
        worldRenderer.func_181668_a(n == null ? drawMode : n, DefaultVertexFormats.field_181705_e);
        if (INSTANCE.area(vertexes) >= 0.0f) {
            ArraysKt.reverse((Object[])vertexes);
        }
        List<Float>[] $this$forEach$iv = vertexes;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i = 0; i < n2; ++i) {
            List<Float> element$iv;
            List<Float> it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            worldRenderer.func_181662_b((double)((Number)it.get(0)).floatValue(), (double)((Number)it.get(1)).floatValue(), 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        INSTANCE.finishDraw();
    }

    public static /* synthetic */ void drawShape$default(long l, List[] listArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 9;
        }
        Renderer.drawShape(l, listArray, n);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawLine(long color, float x1, float y1, float x2, float y2, float thickness, int drawMode) {
        float f = y2 - y1;
        float f2 = x2 - x1;
        float theta = -((float)Math.atan2(f, f2));
        float i = (float)Math.sin(theta) * (thickness / (float)2);
        float j = (float)Math.cos(theta) * (thickness / (float)2);
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        INSTANCE.doColor$ctjs(color);
        Integer n = Renderer.drawMode;
        worldRenderer.func_181668_a(n == null ? drawMode : n, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 + i), (double)(y1 + j), 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + i), (double)(y2 + j), 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - i), (double)(y2 - j), 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 - i), (double)(y1 - j), 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        INSTANCE.finishDraw();
    }

    public static /* synthetic */ void drawLine$default(long l, float f, float f2, float f3, float f4, float f5, int n, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            n = 7;
        }
        Renderer.drawLine(l, f, f2, f3, f4, f5, n);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawCircle(long color, float x, float y, float radius, int steps, int drawMode) {
        double theta = Math.PI * 2 / (double)steps;
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        float xHolder = 0.0f;
        float circleX = 1.0f;
        float circleY = 0.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        INSTANCE.doColor$ctjs(color);
        Integer n = Renderer.drawMode;
        worldRenderer.func_181668_a(n == null ? drawMode : n, DefaultVertexFormats.field_181705_e);
        int n2 = 0;
        if (n2 <= steps) {
            int i;
            do {
                i = n2++;
                worldRenderer.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)(circleX * radius + x), (double)(circleY * radius + y), 0.0).func_181675_d();
                xHolder = circleX;
                circleX = cos * circleX - sin * circleY;
                circleY = sin * xHolder + cos * circleY;
                worldRenderer.func_181662_b((double)(circleX * radius + x), (double)(circleY * radius + y), 0.0).func_181675_d();
            } while (i != steps);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        INSTANCE.finishDraw();
    }

    public static /* synthetic */ void drawCircle$default(long l, float f, float f2, float f3, int n, int n2, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = 5;
        }
        Renderer.drawCircle(l, f, f2, f3, n, n2);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawString(@NotNull String text, float x, float y, boolean shadow) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        FontRenderer fr = INSTANCE.getFontRenderer();
        float newY = 0.0f;
        newY = y;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)ChatLib.addColor(text), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Long l = INSTANCE.getColorized();
            Integer n = l == null ? null : Integer.valueOf((int)l.longValue());
            fr.func_175065_a(it, x, newY, n == null ? (int)Renderer.getWHITE() : n, shadow);
            newY += (float)fr.field_78288_b;
        }
        INSTANCE.finishDraw();
    }

    public static /* synthetic */ void drawString$default(String string, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        Renderer.drawString(string, f, f2, bl);
    }

    @JvmStatic
    public static final void drawStringWithShadow(@NotNull String text, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Renderer.drawString(text, x, y, true);
    }

    @JvmStatic
    public static final void drawImage(@NotNull Image image, double x, double y, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (colorized == null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)50.0f);
        GlStateManager.func_179144_i((int)image.getTexture().func_110552_b());
        GlStateManager.func_179098_w();
        Integer n = drawMode;
        worldRenderer.func_181668_a(n == null ? 7 : n, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b(x, y + height, 0.0).func_181673_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b(x + width, y + height, 0.0).func_181673_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b(x + width, y, 0.0).func_181673_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(x, y, 0.0).func_181673_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        INSTANCE.finishDraw();
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawPlayer(@NotNull Object player, int x, int y, boolean rotate, boolean showNametag, boolean showArmor, boolean showCape, boolean showHeldItem, boolean showArrows) {
        EntityPlayer entityPlayer;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        float mouseX = -30.0f;
        float mouseY = 0.0f;
        if (player instanceof PlayerMP) {
            entityPlayer = ((PlayerMP)player).getPlayer();
        } else {
            EntityPlayerSP entityPlayerSP = Player.getPlayer();
            Intrinsics.checkNotNull((Object)entityPlayerSP);
            entityPlayer = (EntityPlayer)entityPlayerSP;
        }
        EntityPlayer ent = entityPlayer;
        GlStateManager.func_179142_g();
        RenderHelper.func_74519_b();
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        Renderer.translate(x, y, 50.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        Renderer.scale(-1.0f, 1.0f);
        if (!rotate) {
            ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
            ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
            ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
            ent.field_70759_as = ent.field_70177_z;
            ent.field_70758_at = ent.field_70177_z;
        }
        Renderer.renderManager.field_78735_i = 180.0f;
        renderManager.func_178633_a(false);
        boolean isSmall = Intrinsics.areEqual((Object)((AbstractClientPlayer)ent).func_175154_l(), (Object)"slim");
        CTRenderPlayer ctRenderPlayer = isSmall ? slimCTRenderPlayer : normalCTRenderPlayer;
        ctRenderPlayer.setOptions(showNametag, showArmor, showCape, showHeldItem, showArrows);
        ctRenderPlayer.func_76986_a((AbstractClientPlayer)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        renderManager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        INSTANCE.finishDraw();
    }

    public static /* synthetic */ void drawPlayer$default(Object object, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n3, Object object2) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x20) != 0) {
            bl3 = true;
        }
        if ((n3 & 0x40) != 0) {
            bl4 = true;
        }
        if ((n3 & 0x80) != 0) {
            bl5 = true;
        }
        if ((n3 & 0x100) != 0) {
            bl6 = true;
        }
        Renderer.drawPlayer(object, n, n2, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public final void doColor$ctjs(long longColor) {
        int color = (int)longColor;
        if (colorized == null) {
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        }
    }

    @JvmStatic
    public static final void finishDraw() {
        if (!retainTransforms) {
            colorized = null;
            drawMode = null;
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
        }
    }

    private final float area(List<Float>[] points) {
        float area = 0.0f;
        int n = 0;
        int n2 = points.length;
        while (n < n2) {
            int i = n++;
            List<Float> list = points[i];
            float x1 = ((Number)list.get(0)).floatValue();
            float y1 = ((Number)list.get(1)).floatValue();
            List<Float> list2 = points[(i + 1) % points.length];
            float x2 = ((Number)list2.get(0)).floatValue();
            float y2 = ((Number)list2.get(1)).floatValue();
            area += x1 * y2 - x2 * y1;
        }
        return area / (float)2;
    }

    @JvmStatic
    @JvmOverloads
    public static final long color(long red, long green, long blue) {
        return Renderer.color$default(red, green, blue, 0L, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final long getRainbow(float step) {
        return Renderer.getRainbow$default(step, 0.0f, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final int[] getRainbowColors(float step) {
        return Renderer.getRainbowColors$default(step, 0.0f, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void translate(float x, float y) {
        Renderer.translate$default(x, y, 0.0f, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void scale(float scaleX) {
        Renderer.scale$default(scaleX, 0.0f, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void colorize(float red, float green, float blue) {
        Renderer.colorize$default(red, green, blue, 0.0f, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawShape(long color, List<Float> ... vertexes) {
        Intrinsics.checkNotNullParameter(vertexes, (String)"vertexes");
        Renderer.drawShape$default(color, vertexes, 0, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawLine(long color, float x1, float y1, float x2, float y2, float thickness) {
        Renderer.drawLine$default(color, x1, y1, x2, y2, thickness, 0, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawCircle(long color, float x, float y, float radius, int steps) {
        Renderer.drawCircle$default(color, x, y, radius, steps, 0, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawString(@NotNull String text, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Renderer.drawString$default(text, x, y, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawPlayer(@NotNull Object player, int x, int y, boolean rotate, boolean showNametag, boolean showArmor, boolean showCape, boolean showHeldItem) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Renderer.drawPlayer$default(player, x, y, rotate, showNametag, showArmor, showCape, showHeldItem, false, 256, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawPlayer(@NotNull Object player, int x, int y, boolean rotate, boolean showNametag, boolean showArmor, boolean showCape) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Renderer.drawPlayer$default(player, x, y, rotate, showNametag, showArmor, showCape, false, false, 384, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawPlayer(@NotNull Object player, int x, int y, boolean rotate, boolean showNametag, boolean showArmor) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Renderer.drawPlayer$default(player, x, y, rotate, showNametag, showArmor, false, false, false, 448, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawPlayer(@NotNull Object player, int x, int y, boolean rotate, boolean showNametag) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Renderer.drawPlayer$default(player, x, y, rotate, showNametag, false, false, false, false, 480, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawPlayer(@NotNull Object player, int x, int y, boolean rotate) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Renderer.drawPlayer$default(player, x, y, rotate, false, false, false, false, false, 496, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void drawPlayer(@NotNull Object player, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Renderer.drawPlayer$default(player, x, y, false, false, false, false, false, false, 504, null);
    }

    static {
        Tessellator tessellator = Renderer.tessellator = Tessellator.func_178181_a();
        Intrinsics.checkNotNullExpressionValue((Object)tessellator, (String)"tessellator");
        worldRenderer = ExtensionsKt.getRenderer(tessellator);
        BLACK = Renderer.color(0L, 0L, 0L, 255L);
        DARK_BLUE = Renderer.color(0L, 0L, 190L, 255L);
        DARK_GREEN = Renderer.color(0L, 190L, 0L, 255L);
        DARK_AQUA = Renderer.color(0L, 190L, 190L, 255L);
        DARK_RED = Renderer.color(190L, 0L, 0L, 255L);
        DARK_PURPLE = Renderer.color(190L, 0L, 190L, 255L);
        GOLD = Renderer.color(217L, 163L, 52L, 255L);
        GRAY = Renderer.color(190L, 190L, 190L, 255L);
        DARK_GRAY = Renderer.color(63L, 63L, 63L, 255L);
        BLUE = Renderer.color(63L, 63L, 254L, 255L);
        GREEN = Renderer.color(63L, 254L, 63L, 255L);
        AQUA = Renderer.color(63L, 254L, 254L, 255L);
        RED = Renderer.color(254L, 63L, 63L, 255L);
        LIGHT_PURPLE = Renderer.color(254L, 63L, 254L, 255L);
        YELLOW = Renderer.color(254L, 254L, 63L, 255L);
        WHITE = Renderer.color(255L, 255L, 255L, 255L);
        renderManager = Renderer.getRenderManager();
        slimCTRenderPlayer = new CTRenderPlayer(renderManager, true);
        normalCTRenderPlayer = new CTRenderPlayer(renderManager, false);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/chattriggers/ctjs/minecraft/libs/renderer/Renderer$screen;", "", "()V", "getHeight", "", "getScale", "getWidth", "ctjs"})
    public static final class screen {
        @NotNull
        public static final screen INSTANCE = new screen();

        private screen() {
        }

        @JvmStatic
        public static final int getWidth() {
            return new ScaledResolution(Client.Companion.getMinecraft()).func_78326_a();
        }

        @JvmStatic
        public static final int getHeight() {
            return new ScaledResolution(Client.Companion.getMinecraft()).func_78328_b();
        }

        @JvmStatic
        public static final int getScale() {
            return new ScaledResolution(Client.Companion.getMinecraft()).func_78325_e();
        }
    }
}

