/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.libs;

import com.chattriggers.ctjs.CTJS;
import com.chattriggers.ctjs.utils.Config;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u001c\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001e\u001a\u00020\u0011H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0007J\"\u0010\"\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u000eH\u0007J*\u0010\"\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u000eH\u0007\u00a8\u0006%"}, d2={"Lcom/chattriggers/ctjs/minecraft/libs/FileLib;", "", "()V", "absoluteLocation", "", "importName", "fileLocation", "append", "", "toAppend", "fileName", "decodeBase64", "toDecode", "delete", "", "deleteDirectory", "dir", "Ljava/io/File;", "encodeBase64", "toEncode", "exists", "extractFile", "zipIn", "Ljava/util/zip/ZipInputStream;", "filePath", "getUrlContent", "theUrl", "userAgent", "isDirectory", "read", "file", "unzip", "zipFilePath", "destDirectory", "write", "toWrite", "recursive", "ctjs"})
public final class FileLib {
    @NotNull
    public static final FileLib INSTANCE = new FileLib();

    private FileLib() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull String importName, @NotNull String fileName, @NotNull String toWrite, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)toWrite, (String)"toWrite");
        FileLib.write(INSTANCE.absoluteLocation(importName, fileName), toWrite, recursive);
    }

    public static /* synthetic */ void write$default(String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        FileLib.write(string, string2, string3, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull String fileLocation, @NotNull String toWrite, boolean recursive) {
        File file;
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        Intrinsics.checkNotNullParameter((Object)toWrite, (String)"toWrite");
        File $this$write_u24lambda_u2d0 = file = new File(fileLocation);
        boolean bl = false;
        if (recursive && !$this$write_u24lambda_u2d0.exists()) {
            $this$write_u24lambda_u2d0.getParentFile().mkdirs();
        }
        FilesKt.writeText$default((File)file, (String)toWrite, null, (int)2, null);
    }

    public static /* synthetic */ void write$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        FileLib.write(string, string2, bl);
    }

    @JvmStatic
    public static final void append(@NotNull String importName, @NotNull String fileName, @NotNull String toAppend) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)toAppend, (String)"toAppend");
        FileLib.append(INSTANCE.absoluteLocation(importName, fileName), toAppend);
    }

    @JvmStatic
    public static final void append(@NotNull String fileLocation, @NotNull String toAppend) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        Intrinsics.checkNotNullParameter((Object)toAppend, (String)"toAppend");
        FilesKt.appendText$default((File)new File(fileLocation), (String)toAppend, null, (int)2, null);
    }

    @JvmStatic
    @Nullable
    public static final String read(@NotNull String importName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileLib.read(new File(INSTANCE.absoluteLocation(importName, fileName)));
    }

    @JvmStatic
    @Nullable
    public static final String read(@NotNull String fileLocation) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        return FileLib.read(new File(fileLocation));
    }

    @JvmStatic
    @Nullable
    public static final String read(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            string = FilesKt.readText$default((File)file, null, (int)1, null);
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    public static final boolean exists(@NotNull String importName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileLib.exists(INSTANCE.absoluteLocation(importName, fileName));
    }

    @JvmStatic
    public static final boolean exists(@NotNull String fileLocation) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        return new File(fileLocation).exists();
    }

    @JvmStatic
    public static final boolean isDirectory(@NotNull String importName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileLib.isDirectory(INSTANCE.absoluteLocation(importName, fileName));
    }

    @JvmStatic
    public static final boolean isDirectory(@NotNull String fileLocation) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        return new File(fileLocation).isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getUrlContent(@NotNull String theUrl, @Nullable String userAgent) throws UnknownHostException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)theUrl, (String)"theUrl");
        URLConnection conn = CTJS.INSTANCE.makeWebRequest(theUrl);
        Closeable closeable = conn.getInputStream();
        Object object = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byArray = ByteStreamsKt.readBytes((InputStream)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        object = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(\"UTF-8\")");
        Object object2 = object;
        byte[] byArray2 = byArray;
        return new String(byArray2, (Charset)object2);
    }

    public static /* synthetic */ String getUrlContent$default(String string, String string2, int n, Object object) throws UnknownHostException {
        if ((n & 2) != 0) {
            string2 = "Mozilla/5.0";
        }
        return FileLib.getUrlContent(string, string2);
    }

    @JvmStatic
    public static final boolean delete(@NotNull String importName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileLib.delete(INSTANCE.absoluteLocation(importName, fileName));
    }

    @JvmStatic
    public static final boolean delete(@NotNull String fileLocation) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        return new File(fileLocation).delete();
    }

    @JvmStatic
    public static final boolean deleteDirectory(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return FileLib.deleteDirectory(new File(dir));
    }

    @JvmStatic
    public static final boolean deleteDirectory(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return FilesKt.deleteRecursively((File)dir);
    }

    @JvmStatic
    public static final void unzip(@NotNull String zipFilePath, @NotNull String destDirectory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)destDirectory, (String)"destDirectory");
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                INSTANCE.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private final void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        File toWrite = new File(filePath);
        toWrite.getParentFile().mkdirs();
        toWrite.createNewFile();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = zipIn.read(bytesIn);
        while (read != -1) {
            bos.write(bytesIn, 0, read);
            read = zipIn.read(bytesIn);
        }
        bos.close();
    }

    private final String absoluteLocation(String importName, String fileLocation) {
        return Config.INSTANCE.getModulesFolder() + File.separator + importName + File.separator + fileLocation;
    }

    @JvmStatic
    @NotNull
    public static final String encodeBase64(@NotNull String toEncode) {
        Intrinsics.checkNotNullParameter((Object)toEncode, (String)"toEncode");
        Base64.Encoder encoder = Base64.getEncoder();
        String string = toEncode;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string2 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEncoder().encodeToStr\u2026g(toEncode.toByteArray())");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String decodeBase64(@NotNull String toDecode) {
        Intrinsics.checkNotNullParameter((Object)toDecode, (String)"toDecode");
        byte[] byArray = Base64.getDecoder().decode(toDecode);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(toDecode)");
        return new String(byArray, Charsets.UTF_8);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull String importName, @NotNull String fileName, @NotNull String toWrite) {
        Intrinsics.checkNotNullParameter((Object)importName, (String)"importName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)toWrite, (String)"toWrite");
        FileLib.write$default(importName, fileName, toWrite, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull String fileLocation, @NotNull String toWrite) {
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        Intrinsics.checkNotNullParameter((Object)toWrite, (String)"toWrite");
        FileLib.write$default(fileLocation, toWrite, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getUrlContent(@NotNull String theUrl) throws UnknownHostException {
        Intrinsics.checkNotNullParameter((Object)theUrl, (String)"theUrl");
        return FileLib.getUrlContent$default(theUrl, null, 2, null);
    }
}

