/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.libs;

import com.chattriggers.ctjs.minecraft.listeners.CancellableEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007J\u0014\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0005\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/chattriggers/ctjs/minecraft/libs/EventLib;", "", "()V", "cancel", "", "event", "getMessage", "Lnet/minecraft/util/IChatComponent;", "Lcom/chattriggers/ctjs/utils/kotlin/MCITextComponent;", "Lnet/minecraftforge/client/event/ClientChatReceivedEvent;", "getName", "", "Lnet/minecraftforge/client/event/sound/PlaySoundEvent;", "getType", "", "ctjs"})
public final class EventLib {
    @NotNull
    public static final EventLib INSTANCE = new EventLib();

    private EventLib() {
    }

    @JvmStatic
    public static final int getType(@NotNull ClientChatReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return event.type;
    }

    @JvmStatic
    @NotNull
    public static final IChatComponent getMessage(@NotNull ClientChatReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IChatComponent iChatComponent = event.message;
        Intrinsics.checkNotNullExpressionValue((Object)iChatComponent, (String)"event.message");
        return iChatComponent;
    }

    @JvmStatic
    @NotNull
    public static final String getName(@NotNull PlaySoundEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.name");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void cancel(@NotNull Object event) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event;
        if (object instanceof PlaySoundEvent) {
            ((PlaySoundEvent)event).result = null;
            return;
        } else if (object instanceof CancellableEvent) {
            ((CancellableEvent)event).setCanceled(true);
            return;
        } else {
            if (!(object instanceof Event)) throw new IllegalArgumentException(Intrinsics.stringPlus((String)"cancel() expects an Event but received ", (Object)event.getClass().getName()));
            if (!((Event)event).isCancelable()) throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Attempt to cancel non-cancelable event ", (Object)event.getClass().getName()));
            ((Event)event).setCanceled(true);
        }
    }
}

