/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.minecraft.libs;

import com.chattriggers.ctjs.ReferenceKt;
import com.chattriggers.ctjs.minecraft.libs.EventLib;
import com.chattriggers.ctjs.minecraft.libs.renderer.Renderer;
import com.chattriggers.ctjs.minecraft.listeners.ClientListener;
import com.chattriggers.ctjs.minecraft.objects.message.Message;
import com.chattriggers.ctjs.minecraft.objects.message.TextComponent;
import com.chattriggers.ctjs.minecraft.wrappers.Client;
import com.chattriggers.ctjs.minecraft.wrappers.Player;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.regexp.NativeRegExp;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007J\u0014\u0010\r\u001a\u00020\u00042\n\u0010\u000e\u001a\u00020\u000f\"\u00020\u000bH\u0007J\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\u001c\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u0015H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0016H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000bH\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0007H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J*\u0010\u001a\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u0015H\u0002J5\u0010\u001e\u001a\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u00152\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160!\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\"J)\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00162\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160!\"\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010#J)\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000b2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160!\"\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010$J)\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00072\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160!\"\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010%J)\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160!\"\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010&JC\u0010'\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u00152\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160!\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\u0012\u0010*\u001a\u00020\u00072\b\b\u0002\u0010+\u001a\u00020\u0007H\u0007J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070-H\u0007J\u001a\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020\u0012H\u0007J\b\u00102\u001a\u00020\u000bH\u0007J\u000e\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0007J\u0010\u00105\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\u0010\u00106\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\u0017\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007\u00a8\u0006:"}, d2={"Lcom/chattriggers/ctjs/minecraft/libs/ChatLib;", "", "()V", "actionBar", "", "text", "addColor", "", "message", "addToSentMessageHistory", "index", "", "chat", "clearChat", "chatLineIDs", "", "command", "clientSide", "", "deleteChat", "toDelete", "Lkotlin/Function1;", "Lcom/chattriggers/ctjs/minecraft/objects/message/Message;", "chatLineId", "regexp", "Lorg/mozilla/javascript/regexp/NativeRegExp;", "deleteChatLineList", "lineList", "", "Lnet/minecraft/client/gui/ChatLine;", "editChat", "toReplace", "replacements", "", "(Lkotlin/jvm/functions/Function1;[Lcom/chattriggers/ctjs/minecraft/objects/message/Message;)V", "(Lcom/chattriggers/ctjs/minecraft/objects/message/Message;[Lcom/chattriggers/ctjs/minecraft/objects/message/Message;)V", "(I[Lcom/chattriggers/ctjs/minecraft/objects/message/Message;)V", "(Ljava/lang/String;[Lcom/chattriggers/ctjs/minecraft/objects/message/Message;)V", "(Lorg/mozilla/javascript/regexp/NativeRegExp;[Lcom/chattriggers/ctjs/minecraft/objects/message/Message;)V", "editChatLineList", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;[Lcom/chattriggers/ctjs/minecraft/objects/message/Message;)V", "getCenteredText", "getChatBreak", "separator", "getChatLines", "", "getChatMessage", "event", "Lnet/minecraftforge/client/event/ClientChatReceivedEvent;", "formatted", "getChatWidth", "isPlayer", "out", "removeFormatting", "replaceFormatting", "say", "(Ljava/lang/String;)Lkotlin/Unit;", "simulateChat", "ctjs"})
public final class ChatLib {
    @NotNull
    public static final ChatLib INSTANCE = new ChatLib();

    private ChatLib() {
    }

    @JvmStatic
    public static final void chat(@NotNull Object text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = text;
        if (object instanceof String) {
            Object[] objectArray = new Object[]{text};
            new Message(objectArray).chat();
        } else if (object instanceof Message) {
            ((Message)text).chat();
        } else if (object instanceof TextComponent) {
            ((TextComponent)text).chat();
        } else {
            Object[] objectArray = new Object[]{text.toString()};
            new Message(objectArray).chat();
        }
    }

    @JvmStatic
    public static final void actionBar(@NotNull Object text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = text;
        if (object instanceof String) {
            Object[] objectArray = new Object[]{text};
            new Message(objectArray).actionBar();
        } else if (object instanceof Message) {
            ((Message)text).actionBar();
        } else if (object instanceof TextComponent) {
            ((TextComponent)text).actionBar();
        } else {
            Object[] objectArray = new Object[]{text.toString()};
            new Message(objectArray).actionBar();
        }
    }

    @JvmStatic
    public static final void simulateChat(@NotNull Object text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Object object = text;
        if (object instanceof String) {
            Object[] objectArray = new Object[]{text};
            new Message(objectArray).setRecursive(true).chat();
        } else if (object instanceof Message) {
            ((Message)text).setRecursive(true).chat();
        } else if (object instanceof TextComponent) {
            Object[] objectArray = new Object[]{text};
            new Message(objectArray).setRecursive(true).chat();
        } else {
            Object[] objectArray = new Object[]{text.toString()};
            new Message(objectArray).setRecursive(true).chat();
        }
    }

    @JvmStatic
    @Nullable
    public static final Unit say(@NotNull String text) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        EntityPlayerSP entityPlayerSP = Player.getPlayer();
        if (entityPlayerSP == null) {
            unit = null;
        } else {
            entityPlayerSP.func_71165_d(text);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    @JvmStatic
    @JvmOverloads
    public static final void command(@NotNull String text, boolean clientSide) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (clientSide) {
            ClientCommandHandler.instance.func_71556_a((ICommandSender)Player.getPlayer(), Intrinsics.stringPlus((String)"/", (Object)text));
        } else {
            ChatLib.say(Intrinsics.stringPlus((String)"/", (Object)text));
        }
    }

    public static /* synthetic */ void command$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ChatLib.command(string, bl);
    }

    @JvmStatic
    public static final void clearChat(int ... chatLineIDs) {
        Intrinsics.checkNotNullParameter((Object)chatLineIDs, (String)"chatLineIDs");
        if (chatLineIDs.length == 0) {
            GuiNewChat guiNewChat = Client.Companion.getChatGUI();
            if (guiNewChat != null) {
                guiNewChat.func_146231_a();
            }
            return;
        }
        for (int chatLineID : chatLineIDs) {
            GuiNewChat guiNewChat = Client.Companion.getChatGUI();
            if (guiNewChat == null) continue;
            guiNewChat.func_146242_c(chatLineID);
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getChatBreak(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        int len = Renderer.getStringWidth(separator);
        int times = INSTANCE.getChatWidth() / len;
        return ExtensionsKt.times(separator, times);
    }

    public static /* synthetic */ String getChatBreak$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "-";
        }
        return ChatLib.getChatBreak(string);
    }

    @JvmStatic
    public static final int getChatWidth() {
        int n;
        GuiNewChat guiNewChat = Client.Companion.getChatGUI();
        return guiNewChat == null ? 0 : (n = guiNewChat.func_146228_f());
    }

    @JvmStatic
    @NotNull
    public static final String removeFormatting(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("[\u00a7&][0-9a-fk-or]");
        String string = "";
        return regex.replace(charSequence, string);
    }

    @JvmStatic
    @NotNull
    public static final String replaceFormatting(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        Regex regex = new Regex("\u00a7(?![^0-9a-fk-or]|$)");
        String string = "&";
        return regex.replace(charSequence, string);
    }

    @JvmStatic
    @NotNull
    public static final String getCenteredText(@NotNull String text) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int textWidth = Renderer.getStringWidth(ChatLib.addColor(text));
        int chatWidth = INSTANCE.getChatWidth();
        if (textWidth >= chatWidth) {
            return text;
        }
        float spaceWidth = (float)(chatWidth - textWidth) / 2.0f;
        StringBuilder $this$getCenteredText_u24lambda_u2d1 = charSequence = new StringBuilder();
        boolean bl = false;
        int n = MathKt.roundToInt((float)(spaceWidth / (float)Renderer.getStringWidth(" ")));
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            $this$getCenteredText_u24lambda_u2d1.append(' ');
        }
        StringBuilder spaceBuilder = charSequence;
        charSequence = spaceBuilder.append(text).toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"spaceBuilder.append(text).toString()");
        return charSequence;
    }

    @JvmStatic
    public static final void editChat(@NotNull NativeRegExp regexp, Message ... replacements) {
        Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        Object object = regexp.get("global");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean global = (Boolean)object;
        Object object2 = regexp.get("ignoreCase");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean ignoreCase = (Boolean)object2;
        Object object3 = regexp.get("multiline");
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean multiline = (Boolean)object3;
        int flags = (ignoreCase ? 2 : 0) | (multiline ? 8 : 0);
        Object object4 = regexp.get("source");
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Pattern pattern = Pattern.compile((String)object4, flags);
        INSTANCE.editChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(pattern, global){
            final /* synthetic */ Pattern $pattern;
            final /* synthetic */ boolean $global;
            {
                this.$pattern = $pattern;
                this.$global = $global;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Matcher matcher = this.$pattern.matcher(it.getChatMessage().func_150260_c());
                return this.$global ? matcher.find() : matcher.matches();
            }
        }), Arrays.copyOf(replacements, replacements.length));
    }

    @JvmStatic
    public static final void editChat(@NotNull String toReplace, Message ... replacements) {
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        INSTANCE.editChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(toReplace){
            final /* synthetic */ String $toReplace;
            {
                this.$toReplace = $toReplace;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getChatMessage().func_150260_c();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getChatMessage().unformattedText");
                return Intrinsics.areEqual((Object)ChatLib.removeFormatting(string), (Object)this.$toReplace);
            }
        }), Arrays.copyOf(replacements, replacements.length));
    }

    @JvmStatic
    public static final void editChat(@NotNull Message toReplace, Message ... replacements) {
        Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        INSTANCE.editChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(toReplace){
            final /* synthetic */ Message $toReplace;
            {
                this.$toReplace = $toReplace;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$toReplace.getChatMessage().func_150254_d();
                String string2 = it.getChatMessage().func_150254_d();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.getChatMessage().formattedText");
                String string3 = string2.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                return Intrinsics.areEqual((Object)string, (Object)string3);
            }
        }), Arrays.copyOf(replacements, replacements.length));
    }

    @JvmStatic
    public static final void editChat(int chatLineId, Message ... replacements) {
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        INSTANCE.editChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(chatLineId){
            final /* synthetic */ int $chatLineId;
            {
                this.$chatLineId = $chatLineId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return message.getChatLineId() == this.$chatLineId;
            }
        }), Arrays.copyOf(replacements, replacements.length));
    }

    private final void editChat(Function1<? super Message, Boolean> toReplace, Message ... replacements) {
        GuiNewChat guiNewChat = Client.Companion.getChatGUI();
        Intrinsics.checkNotNull((Object)guiNewChat);
        List chatLines = guiNewChat.field_146252_h;
        Intrinsics.checkNotNullExpressionValue((Object)chatLines, (String)"chatLines");
        this.editChatLineList(chatLines, toReplace, Arrays.copyOf(replacements, replacements.length));
        GuiNewChat guiNewChat2 = Client.Companion.getChatGUI();
        Intrinsics.checkNotNull((Object)guiNewChat2);
        guiNewChat2.func_146245_b();
    }

    /*
     * WARNING - void declaration
     */
    private final void editChatLineList(List<ChatLine> lineList, Function1<? super Message, Boolean> toReplace, Message ... replacements) {
        ListIterator<ChatLine> chatLineIterator = lineList.listIterator();
        while (chatLineIterator.hasNext()) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            ChatLine chatLine = chatLineIterator.next();
            IChatComponent iChatComponent = chatLine.func_151461_a();
            Intrinsics.checkNotNullExpressionValue((Object)iChatComponent, (String)"chatLine.chatComponent");
            boolean result = (Boolean)toReplace.invoke((Object)new Message(iChatComponent).setChatLineId(chatLine.func_74539_c()));
            if (!result) continue;
            chatLineIterator.remove();
            Object $this$map$iv = replacements;
            boolean $i$f$map = false;
            Message[] messageArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Message[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_16 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int lineId = it.getChatLineId() == -1 ? 0 : it.getChatLineId();
                collection.add(new ChatLine(chatLine.func_74540_b(), it.getChatMessage(), lineId));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChatLine p0 = (ChatLine)element$iv;
                boolean bl = false;
                chatLineIterator.add(p0);
            }
        }
    }

    @JvmStatic
    public static final void deleteChat(@NotNull NativeRegExp regexp) {
        Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
        Object object = regexp.get("global");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean global = (Boolean)object;
        Object object2 = regexp.get("ignoreCase");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean ignoreCase = (Boolean)object2;
        Object object3 = regexp.get("multiline");
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean multiline = (Boolean)object3;
        int flags = (ignoreCase ? 2 : 0) | (multiline ? 8 : 0);
        Object object4 = regexp.get("source");
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Pattern pattern = Pattern.compile((String)object4, flags);
        INSTANCE.deleteChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(pattern, global){
            final /* synthetic */ Pattern $pattern;
            final /* synthetic */ boolean $global;
            {
                this.$pattern = $pattern;
                this.$global = $global;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Matcher matcher = this.$pattern.matcher(it.getChatMessage().func_150260_c());
                return this.$global ? matcher.find() : matcher.matches();
            }
        }));
    }

    @JvmStatic
    public static final void deleteChat(@NotNull String toDelete) {
        Intrinsics.checkNotNullParameter((Object)toDelete, (String)"toDelete");
        INSTANCE.deleteChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(toDelete){
            final /* synthetic */ String $toDelete;
            {
                this.$toDelete = $toDelete;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getChatMessage().func_150260_c();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getChatMessage().unformattedText");
                return Intrinsics.areEqual((Object)ChatLib.removeFormatting(string), (Object)this.$toDelete);
            }
        }));
    }

    @JvmStatic
    public static final void deleteChat(@NotNull Message toDelete) {
        Intrinsics.checkNotNullParameter((Object)toDelete, (String)"toDelete");
        INSTANCE.deleteChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(toDelete){
            final /* synthetic */ Message $toDelete;
            {
                this.$toDelete = $toDelete;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$toDelete.getChatMessage().func_150254_d();
                String string2 = it.getChatMessage().func_150254_d();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.getChatMessage().formattedText");
                String string3 = string2.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                return Intrinsics.areEqual((Object)string, (Object)string3);
            }
        }));
    }

    @JvmStatic
    public static final void deleteChat(int chatLineId) {
        INSTANCE.deleteChat((Function1<? super Message, Boolean>)((Function1)new Function1<Message, Boolean>(chatLineId){
            final /* synthetic */ int $chatLineId;
            {
                this.$chatLineId = $chatLineId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Message it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getChatLineId() == this.$chatLineId;
            }
        }));
    }

    private final void deleteChat(Function1<? super Message, Boolean> toDelete) {
        GuiNewChat guiNewChat = Client.Companion.getChatGUI();
        Intrinsics.checkNotNull((Object)guiNewChat);
        List chatLines = guiNewChat.field_146252_h;
        Intrinsics.checkNotNullExpressionValue((Object)chatLines, (String)"chatLines");
        this.deleteChatLineList(chatLines, toDelete);
        GuiNewChat guiNewChat2 = Client.Companion.getChatGUI();
        Intrinsics.checkNotNull((Object)guiNewChat2);
        guiNewChat2.func_146245_b();
    }

    private final void deleteChatLineList(List<ChatLine> lineList, Function1<? super Message, Boolean> toDelete) {
        ListIterator<ChatLine> chatLineIterator = lineList.listIterator();
        while (chatLineIterator.hasNext()) {
            ChatLine chatLine = chatLineIterator.next();
            IChatComponent iChatComponent = chatLine.func_151461_a();
            Intrinsics.checkNotNullExpressionValue((Object)iChatComponent, (String)"chatLine.chatComponent");
            if (!((Boolean)toDelete.invoke((Object)new Message(iChatComponent).setChatLineId(chatLine.func_74539_c()))).booleanValue()) continue;
            chatLineIterator.remove();
        }
    }

    @JvmStatic
    @NotNull
    public static final List<String> getChatLines() {
        List hist = CollectionsKt.toMutableList((Collection)ClientListener.INSTANCE.getChatHistory());
        CollectionsKt.reverse((List)hist);
        return hist;
    }

    @JvmStatic
    @JvmOverloads
    public static final void addToSentMessageHistory(int index, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GuiNewChat guiNewChat = Client.Companion.getChatGUI();
        Intrinsics.checkNotNull((Object)guiNewChat);
        List sentMessages = guiNewChat.func_146238_c();
        if (index == -1) {
            sentMessages.add(message);
        } else {
            sentMessages.add(index, message);
        }
    }

    public static /* synthetic */ void addToSentMessageHistory$default(int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        ChatLib.addToSentMessageHistory(n, string);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getChatMessage(@NotNull ClientChatReceivedEvent event, boolean formatted) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (formatted) {
            String string2 = EventLib.getMessage(event).func_150254_d();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(event).formattedText");
            string = ChatLib.replaceFormatting(string2);
        } else {
            String string3 = EventLib.getMessage(event).func_150260_c();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            EventLib.g\u2026unformattedText\n        }");
            string = string3;
        }
        return string;
    }

    public static /* synthetic */ String getChatMessage$default(ClientChatReceivedEvent clientChatReceivedEvent, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ChatLib.getChatMessage(clientChatReceivedEvent, bl);
    }

    @JvmStatic
    @NotNull
    public static final String addColor(@Nullable String message) {
        CharSequence charSequence = String.valueOf(message);
        Regex regex = new Regex("(?<!\\\\)&(?![^0-9a-fk-or]|$)");
        String string = "\u00a7";
        return regex.replace(charSequence, string);
    }

    public final boolean isPlayer(@NotNull String out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (Player.getPlayer() == null) {
            ReferenceKt.printToConsole$default(out, null, null, 3, null);
            return false;
        }
        return true;
    }

    @JvmStatic
    @JvmOverloads
    public static final void command(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ChatLib.command$default(text, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getChatBreak() {
        return ChatLib.getChatBreak$default(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void addToSentMessageHistory(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ChatLib.addToSentMessageHistory$default(0, message, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String getChatMessage(@NotNull ClientChatReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return ChatLib.getChatMessage$default(event, false, 2, null);
    }
}

