/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.loader;

import com.chattriggers.ctjs.engine.module.ModuleManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class UriScheme {
    private static final String PROTOCOL = "chattriggers://";
    private static final int PORT = 21965;
    private static final String QUOTE = "\"";

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("No URL found, aborting...");
            return;
        }
        if (!args[0].startsWith(PROTOCOL)) {
            System.out.println("URL found is not supported, aborting...");
            System.out.println(args[0]);
            return;
        }
        String url = args[0];
        System.out.println("Trying to work with URL: " + url);
        String module = url.substring(PROTOCOL.length()).replace("/", "");
        try {
            UriScheme.connectWithSockets(module);
        }
        catch (Exception e) {
            UriScheme.copyModuleIn(module);
        }
    }

    public static void installUriScheme() {
        try {
            UriScheme.regAdd(" /f /ve /d " + UriScheme.quote("URL:chattriggers Protocol"));
            UriScheme.regAdd(" /f /v " + UriScheme.quote("URL Protocol") + " /d " + UriScheme.quote(""));
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get("chattriggers");
            String modJar = container.getSource().getAbsolutePath();
            String sep = File.separator;
            String javaProgram = System.getProperty("java.home") + sep + "bin" + sep + "javaw.exe";
            String value = (QUOTE + javaProgram + "\" -cp \"" + modJar + "\" com.chattriggers.ctjs.loader.UriScheme \"%1\"").replace(QUOTE, "\\\"");
            UriScheme.regAdd("\\shell\\open\\command /f /ve /d \"" + value + QUOTE);
        }
        catch (Exception e) {
            System.err.println("Unable to install chattriggers URI scheme, disregard if OS is not Windows");
        }
    }

    public static void createSocketListener() {
        new Thread(UriScheme::socketListener, "CTJSSocketListener").start();
    }

    private static String quote(String toQuote) {
        return QUOTE + toQuote + QUOTE;
    }

    private static void regAdd(String args) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("REG ADD HKCU\\Software\\Classes\\chattriggers" + args);
        if (process.waitFor() != 0) {
            throw new IOException("Error editing registry!");
        }
    }

    private static void socketListener() {
        block28: {
            try {
                ServerSocket serverSocket = new ServerSocket(21965);
                Throwable throwable = null;
                block22: while (true) {
                    try {
                        while (!Thread.interrupted()) {
                            try {
                                Socket clientSocket = serverSocket.accept();
                                Throwable throwable2 = null;
                                try {
                                    InputStream inputStream = clientSocket.getInputStream();
                                    String module = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                                    ModuleManager.INSTANCE.importModule(module);
                                    continue block22;
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (clientSocket == null) continue block22;
                                    if (throwable2 != null) {
                                        try {
                                            clientSocket.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue block22;
                                    }
                                    clientSocket.close();
                                    continue block22;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        break block28;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                finally {
                    if (serverSocket != null) {
                        if (throwable != null) {
                            try {
                                serverSocket.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            serverSocket.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void connectWithSockets(String module) throws Exception {
        Socket socket = new Socket(InetAddress.getLocalHost(), 21965);
        socket.getOutputStream().write(module.getBytes());
        socket.close();
    }

    private static void copyModuleIn(String module) {
        System.out.println("Adding module named " + module + " to the to download list!");
        String dataFolder = System.getenv("APPDATA");
        File modulesDir = new File(dataFolder + "\\.minecraft\\config\\ChatTriggers\\modules");
        File toDownload = new File(modulesDir, ".to_download.txt");
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(toDownload, true));
            pw.append(module).append(",");
            pw.close();
        }
        catch (Exception e) {
            System.out.println("Error writing to file.");
        }
    }
}

