/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.engine.module;

import com.chattriggers.ctjs.CTJS;
import com.chattriggers.ctjs.ReferenceKt;
import com.chattriggers.ctjs.engine.module.Module;
import com.chattriggers.ctjs.engine.module.ModuleManager;
import com.chattriggers.ctjs.engine.module.ModuleMetadata;
import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.utils.Config;
import com.chattriggers.ctjs.utils.console.LogType;
import com.chattriggers.ctjs.utils.kotlin.ExtensionsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/chattriggers/ctjs/engine/module/ModuleUpdater;", "", "()V", "changelogs", "", "Lcom/chattriggers/ctjs/engine/module/ModuleMetadata;", "shouldReportChangelog", "", "downloadModule", "Lcom/chattriggers/ctjs/engine/module/ModuleUpdater$DownloadResult;", "name", "", "importModule", "", "Lcom/chattriggers/ctjs/engine/module/Module;", "moduleName", "requiredBy", "importPendingModules", "", "onRenderGameOverlay", "event", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Text;", "onWorldLoad", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "reportChangelog", "module", "tryReportChangelog", "updateModule", "DownloadResult", "ctjs"})
public final class ModuleUpdater {
    @NotNull
    public static final ModuleUpdater INSTANCE = new ModuleUpdater();
    @NotNull
    private static final List<ModuleMetadata> changelogs = new ArrayList();
    private static boolean shouldReportChangelog;

    private ModuleUpdater() {
    }

    @SubscribeEvent
    public final void onWorldLoad(@NotNull WorldEvent.Load event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        shouldReportChangelog = true;
    }

    @SubscribeEvent
    public final void onRenderGameOverlay(@NotNull RenderGameOverlayEvent.Text event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!shouldReportChangelog) {
            return;
        }
        Iterable $this$forEach$iv = changelogs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleMetadata p0 = (ModuleMetadata)element$iv;
            boolean bl = false;
            this.reportChangelog(p0);
        }
        changelogs.clear();
    }

    private final void tryReportChangelog(ModuleMetadata module) {
        if (shouldReportChangelog) {
            this.reportChangelog(module);
        } else {
            changelogs.add(module);
        }
    }

    private final void reportChangelog(ModuleMetadata module) {
        ChatLib.chat("&a[ChatTriggers] " + module.getName() + " has updated to version " + module.getVersion());
        ChatLib.chat(Intrinsics.stringPlus((String)"&aChangelog: &r", (Object)module.getChangelog()));
    }

    /*
     * WARNING - void declaration
     */
    public final void importPendingModules() {
        void $this$filterTo$iv$iv;
        File toDownload = new File(ModuleManager.INSTANCE.getModulesFolder(), ".to_download.txt");
        if (!toDownload.exists()) {
            return;
        }
        String[] stringArray = new String[]{","};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)FilesKt.readText$default((File)toDownload, null, (int)1, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            ModuleUpdater.importModule$default(this, p0, null, 2, null);
        }
        toDownload.delete();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!Config.INSTANCE.getAutoUpdateModules()) {
            return;
        }
        ModuleMetadata metadata = module.getMetadata();
        try {
            void it;
            if (metadata.getName() == null) {
                return;
            }
            ReferenceKt.printToConsole$default(Intrinsics.stringPlus((String)"Checking for update in ", (Object)metadata.getName()), null, null, 3, null);
            String url = "https://www.chattriggers.com/api/modules/" + metadata.getName() + "/metadata?modVersion=2.2.0";
            URLConnection connection = CTJS.INSTANCE.makeWebRequest(url);
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.getInputStream()");
            Object object = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, (Charset)object);
            int n = 8192;
            String newMetadataText = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            ModuleMetadata newMetadata = (ModuleMetadata)CTJS.INSTANCE.getGson().fromJson(newMetadataText, ModuleMetadata.class);
            if (newMetadata.getVersion() == null) {
                ReferenceKt.printToConsole$default("Remote version of module " + metadata.getName() + " has no version numbers, so it will not be updated!", null, LogType.WARN, 1, null);
                return;
            }
            if (metadata.getVersion() != null && ExtensionsKt.toVersion(metadata.getVersion()).compareTo(ExtensionsKt.toVersion(newMetadata.getVersion())) >= 0) {
                return;
            }
            this.downloadModule(metadata.getName());
            ReferenceKt.printToConsole$default(Intrinsics.stringPlus((String)"Updated module ", (Object)metadata.getName()), null, null, 3, null);
            File file = new File(module.getFolder(), "metadata.json");
            Module module2 = module;
            boolean bl = false;
            object = (ModuleMetadata)CTJS.INSTANCE.getGson().fromJson(FilesKt.readText$default((File)it, null, (int)1, null), ModuleMetadata.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"File(module.folder, \"met\u2026class.java)\n            }");
            module2.setMetadata((ModuleMetadata)object);
            if (Config.INSTANCE.getModuleChangelog() && module.getMetadata().getChangelog() != null) {
                this.tryReportChangelog(module.getMetadata());
            }
        }
        catch (Exception e) {
            ReferenceKt.printToConsole$default(Intrinsics.stringPlus((String)"Can't find page for ", (Object)metadata.getName()), null, LogType.WARN, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Module> importModule(@NotNull String moduleName, @Nullable String requiredBy) {
        List list;
        boolean alreadyImported;
        block12: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Iterable $this$any$iv = ModuleManager.INSTANCE.getCachedModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    Module it = (Module)element$iv;
                    boolean bl3 = false;
                    if (StringsKt.equals((String)it.getName(), (String)moduleName, (boolean)true)) {
                        if (requiredBy != null) {
                            it.getMetadata().setRequired(true);
                            it.getRequiredBy().add(requiredBy);
                        }
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block12;
                }
                bl = alreadyImported = false;
            }
        }
        if (alreadyImported) {
            return CollectionsKt.emptyList();
        }
        DownloadResult downloadResult = this.downloadModule(moduleName);
        if (downloadResult == null) {
            return CollectionsKt.emptyList();
        }
        DownloadResult downloadResult2 = downloadResult;
        String realName = downloadResult2.component1();
        String modVersion = downloadResult2.component2();
        File moduleDir = new File(ModuleManager.INSTANCE.getModulesFolder(), realName);
        Module module = ModuleManager.INSTANCE.parseModule(moduleDir);
        module.setTargetModVersion(ExtensionsKt.toVersion(modVersion));
        if (requiredBy != null) {
            module.getMetadata().setRequired(true);
            module.getRequiredBy().add(requiredBy);
        }
        ModuleManager.INSTANCE.getCachedModules().add(module);
        CollectionsKt.sortWith(ModuleManager.INSTANCE.getCachedModules(), ModuleUpdater::importModule$lambda-3);
        Collection collection = CollectionsKt.listOf((Object)module);
        ArrayList<String> arrayList = module.getMetadata().getRequires();
        if (arrayList == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = arrayList;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            void var14_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(INSTANCE.importModule((String)it, module.getName()));
            }
            collection = collection2;
            List list2 = (List)destination$iv$iv;
            list = CollectionsKt.flatten((Iterable)list2);
        }
        List list3 = list;
        return CollectionsKt.plus((Collection)collection, (Iterable)(list3 == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)list3));
    }

    public static /* synthetic */ List importModule$default(ModuleUpdater moduleUpdater, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return moduleUpdater.importModule(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DownloadResult downloadModule(String name) {
        block12: {
            File downloadZip = new File(ModuleManager.INSTANCE.getModulesFolder(), "currDownload.zip");
            try {
                DownloadResult downloadResult;
                String url = "https://www.chattriggers.com/api/modules/" + name + "/scripts?modVersion=2.2.0";
                URLConnection connection = CTJS.INSTANCE.makeWebRequest(url);
                FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)downloadZip);
                Closeable closeable = FileSystems.newFileSystem(downloadZip.toPath(), null);
                Throwable throwable = null;
                try {
                    FileSystem it = (FileSystem)closeable;
                    boolean bl = false;
                    Iterable<Path> iterable = it.getRootDirectories();
                    Intrinsics.checkNotNullExpressionValue(iterable, (String)"it.rootDirectories");
                    Iterator<Path> iterator = Files.newDirectoryStream((Path)CollectionsKt.first(iterable)).iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator, (String)"newDirectoryStream(it.ro\u2026ories.first()).iterator()");
                    Iterator<Path> rootFolder = iterator;
                    if (!rootFolder.hasNext()) {
                        throw new Exception("Too small");
                    }
                    Path moduleFolder = rootFolder.next();
                    if (rootFolder.hasNext()) {
                        throw new Exception("Too big");
                    }
                    Object object = new char[]{File.separatorChar};
                    String realName = StringsKt.trimEnd((String)((Object)moduleFolder.getFileName()).toString(), (char[])object);
                    char[] $this$downloadModule_u24lambda_u2d7_u24lambda_u2d5 = object = (Object)new File(ModuleManager.INSTANCE.getModulesFolder(), realName);
                    boolean bl2 = false;
                    $this$downloadModule_u24lambda_u2d7_u24lambda_u2d5.mkdir();
                    Files.walk(moduleFolder, new FileVisitOption[0]).forEach(ModuleUpdater::downloadModule$lambda-7$lambda-6);
                    object = connection.getHeaderField("CT-Version");
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connection.getHeaderField(\"CT-Version\")");
                    downloadResult = new DownloadResult(realName, (String)object);
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)closeable, throwable);
                            throw throwable3;
                        }
                    }
                    catch (Exception exception) {
                        ReferenceKt.printTraceToConsole$default(exception, null, 1, null);
                        break block12;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                DownloadResult downloadResult2 = downloadResult;
                return downloadResult2;
            }
            finally {
                downloadZip.delete();
            }
        }
        return null;
    }

    private static final int importModule$lambda-3(Module a, Module b) {
        return a.getName().compareTo(b.getName());
    }

    private static final void downloadModule$lambda-7$lambda-6(Path path) {
        Object[] objectArray = new String[]{((Object)path).toString()};
        Path resolvedPath = Paths.get(ModuleManager.INSTANCE.getModulesFolder().toString(), (String[])objectArray);
        if (Files.isDirectory(resolvedPath, new LinkOption[0])) {
            return;
        }
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(path, resolvedPath, (CopyOption[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/chattriggers/ctjs/engine/module/ModuleUpdater$DownloadResult;", "", "name", "", "modVersion", "(Ljava/lang/String;Ljava/lang/String;)V", "getModVersion", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ctjs"})
    public static final class DownloadResult {
        @NotNull
        private final String name;
        @NotNull
        private final String modVersion;

        public DownloadResult(@NotNull String name, @NotNull String modVersion) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)modVersion, (String)"modVersion");
            this.name = name;
            this.modVersion = modVersion;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getModVersion() {
            return this.modVersion;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.modVersion;
        }

        @NotNull
        public final DownloadResult copy(@NotNull String name, @NotNull String modVersion) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)modVersion, (String)"modVersion");
            return new DownloadResult(name, modVersion);
        }

        public static /* synthetic */ DownloadResult copy$default(DownloadResult downloadResult, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = downloadResult.name;
            }
            if ((n & 2) != 0) {
                string2 = downloadResult.modVersion;
            }
            return downloadResult.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "DownloadResult(name=" + this.name + ", modVersion=" + this.modVersion + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.modVersion.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadResult)) {
                return false;
            }
            DownloadResult downloadResult = (DownloadResult)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)downloadResult.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.modVersion, (Object)downloadResult.modVersion);
        }
    }
}

