/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs.engine.module;

import com.chattriggers.ctjs.engine.module.Module;
import com.chattriggers.ctjs.engine.module.ModuleManager;
import com.chattriggers.ctjs.engine.module.ModuleMetadata;
import com.chattriggers.ctjs.minecraft.libs.ChatLib;
import com.chattriggers.ctjs.minecraft.libs.renderer.Renderer;
import com.chattriggers.ctjs.minecraft.libs.renderer.Text;
import com.fasterxml.jackson.core.Version;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\t\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003*\u0001\f\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&J\u001e\u0010'\u001a\u00020&2\u0006\u0010\"\u001a\u00020&2\u0006\u0010$\u001a\u00020&2\u0006\u0010%\u001a\u00020&J\b\u0010(\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006)"}, d2={"Lcom/chattriggers/ctjs/engine/module/Module;", "", "name", "", "metadata", "Lcom/chattriggers/ctjs/engine/module/ModuleMetadata;", "folder", "Ljava/io/File;", "(Ljava/lang/String;Lcom/chattriggers/ctjs/engine/module/ModuleMetadata;Ljava/io/File;)V", "getFolder", "()Ljava/io/File;", "gui", "com/chattriggers/ctjs/engine/module/Module$gui$1", "Lcom/chattriggers/ctjs/engine/module/Module$gui$1;", "getMetadata", "()Lcom/chattriggers/ctjs/engine/module/ModuleMetadata;", "setMetadata", "(Lcom/chattriggers/ctjs/engine/module/ModuleMetadata;)V", "getName", "()Ljava/lang/String;", "requiredBy", "", "getRequiredBy", "()Ljava/util/Set;", "setRequiredBy", "(Ljava/util/Set;)V", "targetModVersion", "Lcom/fasterxml/jackson/core/Version;", "getTargetModVersion", "()Lcom/fasterxml/jackson/core/Version;", "setTargetModVersion", "(Lcom/fasterxml/jackson/core/Version;)V", "click", "", "x", "", "y", "width", "", "draw", "toString", "ctjs"})
public final class Module {
    @NotNull
    private final String name;
    @NotNull
    private ModuleMetadata metadata;
    @NotNull
    private final File folder;
    @Nullable
    private Version targetModVersion;
    @NotNull
    private Set<String> requiredBy;
    @NotNull
    private final gui.1 gui;

    public Module(@NotNull String name, @NotNull ModuleMetadata metadata, @NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.name = name;
        this.metadata = metadata;
        this.folder = folder;
        this.requiredBy = new LinkedHashSet();
        this.gui = new Object(this){
            private boolean collapsed;
            private float x;
            private float y;
            @NotNull
            private Text description;
            final /* synthetic */ Module this$0;
            {
                this.this$0 = $receiver;
                this.collapsed = true;
                String string = this.this$0.getMetadata().getDescription();
                if (string == null) {
                    string = "No description provided in the metadata";
                }
                this.description = new Text(string, 0.0f, 0.0f, 6, null);
            }

            public final boolean getCollapsed() {
                return this.collapsed;
            }

            public final void setCollapsed(boolean bl) {
                this.collapsed = bl;
            }

            public final float getX() {
                return this.x;
            }

            public final void setX(float f) {
                this.x = f;
            }

            public final float getY() {
                return this.y;
            }

            public final void setY(float f) {
                this.y = f;
            }

            @NotNull
            public final Text getDescription() {
                return this.description;
            }

            public final void setDescription(@NotNull Text text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"<set-?>");
                this.description = text;
            }
        };
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ModuleMetadata getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@NotNull ModuleMetadata moduleMetadata) {
        Intrinsics.checkNotNullParameter((Object)moduleMetadata, (String)"<set-?>");
        this.metadata = moduleMetadata;
    }

    @NotNull
    public final File getFolder() {
        return this.folder;
    }

    @Nullable
    public final Version getTargetModVersion() {
        return this.targetModVersion;
    }

    public final void setTargetModVersion(@Nullable Version version) {
        this.targetModVersion = version;
    }

    @NotNull
    public final Set<String> getRequiredBy() {
        return this.requiredBy;
    }

    public final void setRequiredBy(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.requiredBy = set;
    }

    public final float draw(float x, float y, float width) {
        float f;
        this.gui.setX(x);
        this.gui.setY(y);
        Renderer.drawRect(0xAA000000L, x, y, width, 13.0f);
        String string = this.metadata.getName();
        if (string == null) {
            string = this.name;
        }
        Renderer.drawStringWithShadow(string, x + (float)3, y + (float)3);
        if (this.gui.getCollapsed()) {
            Renderer.translate$default(x + width - (float)5, y + (float)8, 0.0f, 4, null);
            Renderer.rotate(180.0f);
            Renderer.drawString$default("^", 0.0f, 0.0f, false, 8, null);
            f = 15.0f;
        } else {
            this.gui.getDescription().setMaxWidth((int)width - 5);
            Renderer.drawRect(0x50000000L, x, y + (float)13, width, this.gui.getDescription().getHeight() + (float)12);
            Renderer.drawString$default("^", x + width - (float)10, y + (float)5, false, 8, null);
            this.gui.getDescription().draw(Float.valueOf(x + (float)3), Float.valueOf(y + (float)15));
            if (this.metadata.getVersion() != null) {
                Renderer.drawStringWithShadow(ChatLib.addColor(Intrinsics.stringPlus((String)"&8v", (Object)this.metadata.getVersion())), x + width - (float)Renderer.getStringWidth(ChatLib.addColor(Intrinsics.stringPlus((String)"&8v", (Object)this.metadata.getVersion()))), y + this.gui.getDescription().getHeight() + (float)15);
            }
            Renderer.drawStringWithShadow(ChatLib.addColor(this.metadata.isRequired() && !((Collection)this.requiredBy).isEmpty() ? Intrinsics.stringPlus((String)"&8required by ", this.requiredBy) : "&4[delete]"), x + (float)3, y + this.gui.getDescription().getHeight() + (float)15);
            f = this.gui.getDescription().getHeight() + (float)27;
        }
        return f;
    }

    public final void click(int x, int y, float width) {
        if ((float)x > this.gui.getX() && (float)x < this.gui.getX() + width && (float)y > this.gui.getY() && (float)y < this.gui.getY() + (float)13) {
            this.gui.setCollapsed(!this.gui.getCollapsed());
            return;
        }
        if (this.gui.getCollapsed() || this.metadata.isRequired() && !((Collection)this.requiredBy).isEmpty()) {
            return;
        }
        if ((float)x > this.gui.getX() && (float)x < this.gui.getX() + (float)45 && (float)y > this.gui.getY() + this.gui.getDescription().getHeight() + (float)15 && (float)y < this.gui.getY() + this.gui.getDescription().getHeight() + (float)25) {
            ModuleManager.INSTANCE.deleteModule(this.name);
        }
    }

    @NotNull
    public String toString() {
        return "Module{name=" + this.name + ",version=" + this.metadata.getVersion() + '}';
    }
}

