/*
 * Decompiled with CFR 0.152.
 */
package com.chattriggers.ctjs;

import com.chattriggers.ctjs.CTJS;
import com.chattriggers.ctjs.commands.CTCommand;
import com.chattriggers.ctjs.engine.module.ModuleManager;
import com.chattriggers.ctjs.engine.module.ModuleUpdater;
import com.chattriggers.ctjs.loader.UriScheme;
import com.chattriggers.ctjs.minecraft.libs.renderer.Image;
import com.chattriggers.ctjs.minecraft.listeners.ClientListener;
import com.chattriggers.ctjs.minecraft.listeners.MouseListener;
import com.chattriggers.ctjs.minecraft.listeners.WorldListener;
import com.chattriggers.ctjs.minecraft.objects.Sound;
import com.chattriggers.ctjs.minecraft.objects.gui.GuiHandler;
import com.chattriggers.ctjs.minecraft.wrappers.CPS;
import com.chattriggers.ctjs.minecraft.wrappers.Player;
import com.chattriggers.ctjs.triggers.ForgeTrigger;
import com.chattriggers.ctjs.triggers.TriggerType;
import com.chattriggers.ctjs.utils.Config;
import com.chattriggers.ctjs.utils.UpdateChecker;
import com.google.gson.Gson;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import org.jetbrains.annotations.NotNull;

@Mod(modid="chattriggers", name="ChatTriggers", version="2.2.0", clientSideOnly=true, modLanguage="Kotlin", modLanguageAdapter="gg.essential.api.utils.KotlinAdapter", acceptedMinecraftVersions="[1.8.9]")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010#\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/chattriggers/ctjs/CTJS;", "", "()V", "WEBSITE_ROOT", "", "assetsDir", "Ljava/io/File;", "getAssetsDir", "()Ljava/io/File;", "configLocation", "getConfigLocation", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "images", "", "Lcom/chattriggers/ctjs/minecraft/libs/renderer/Image;", "getImages", "()Ljava/util/Set;", "sounds", "", "Lcom/chattriggers/ctjs/minecraft/objects/Sound;", "getSounds", "()Ljava/util/List;", "init", "", "event", "Lnet/minecraftforge/fml/common/event/FMLInitializationEvent;", "makeWebRequest", "Ljava/net/URLConnection;", "url", "preInit", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "registerHooks", "reportHashedUUID", "ctjs"})
public final class CTJS {
    @NotNull
    public static final CTJS INSTANCE;
    @NotNull
    public static final String WEBSITE_ROOT = "https://www.chattriggers.com";
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final File configLocation;
    @NotNull
    private static final File assetsDir;
    @NotNull
    private static final List<Sound> sounds;
    @NotNull
    private static final Set<Image> images;

    private CTJS() {
    }

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final File getConfigLocation() {
        return configLocation;
    }

    @NotNull
    public final File getAssetsDir() {
        return assetsDir;
    }

    @NotNull
    public final List<Sound> getSounds() {
        return sounds;
    }

    @NotNull
    public final Set<Image> getImages() {
        return images;
    }

    /*
     * WARNING - void declaration
     */
    @Mod.EventHandler
    public final void preInit(@NotNull FMLPreInitializationEvent event) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = new Object[]{WorldListener.INSTANCE, CPS.INSTANCE, GuiHandler.INSTANCE, ClientListener.INSTANCE, UpdateChecker.INSTANCE, MouseListener.INSTANCE, ModuleUpdater.INSTANCE, ForgeTrigger.Companion};
        object = CollectionsKt.listOf((Object[])object);
        EventBus eventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)eventBus, (String)"EVENT_BUS");
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object p0 = element$iv = iterator.next();
            boolean bl = false;
            eventBus.register(p0);
        }
        UriScheme.installUriScheme();
        UriScheme.createSocketListener();
    }

    @Mod.EventHandler
    public final void init(@NotNull FMLInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Config.INSTANCE.loadData();
        if (Config.INSTANCE.getThreadedLoading()) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)init.1.INSTANCE, (int)31, null);
        } else {
            ModuleManager.entryPass$default(ModuleManager.INSTANCE, null, null, 3, null);
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)init.2.INSTANCE, (int)31, null);
        }
        this.registerHooks();
    }

    @NotNull
    public final URLConnection makeWebRequest(@NotNull String url) {
        URLConnection uRLConnection;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection $this$makeWebRequest_u24lambda_u2d1 = uRLConnection = new URL(url).openConnection();
        boolean bl = false;
        $this$makeWebRequest_u24lambda_u2d1.setRequestProperty("User-Agent", "Mozilla/5.0 (ChatTriggers)");
        $this$makeWebRequest_u24lambda_u2d1.setConnectTimeout(3000);
        $this$makeWebRequest_u24lambda_u2d1.setReadTimeout(3000);
        URLConnection uRLConnection2 = uRLConnection;
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection2, (String)"URL(url).openConnection(\u2026 readTimeout = 3000\n    }");
        return uRLConnection2;
    }

    private final void registerHooks() {
        ClientCommandHandler.instance.func_71560_a((ICommand)CTCommand.INSTANCE);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> TriggerType.GameUnload.triggerAll(new Object[0])));
    }

    private final void reportHashedUUID() {
        byte[] uuid = StringsKt.encodeToByteArray((String)Player.getUUID());
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "";
        }
        byte[] salt = StringsKt.encodeToByteArray((String)string);
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(salt);
        byte[] hashedUUID = md.digest(uuid);
        String hash = Base64.getUrlEncoder().encodeToString(hashedUUID);
        String url = "https://www.chattriggers.com/api/statistics/track?hash=" + hash + "&version=2.2.0";
        URLConnection connection = this.makeWebRequest(url);
        connection.getInputStream();
    }

    public static final /* synthetic */ void access$reportHashedUUID(CTJS $this) {
        $this.reportHashedUUID();
    }

    static {
        File file;
        INSTANCE = new CTJS();
        gson = new Gson();
        configLocation = new File("./config");
        File $this$assetsDir_u24lambda_u2d0 = file = new File(configLocation, "ChatTriggers/images/");
        boolean bl = false;
        $this$assetsDir_u24lambda_u2d0.mkdirs();
        assetsDir = file;
        sounds = new ArrayList();
        images = new LinkedHashSet();
    }
}

