/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.Sys;
import ru.vidtu.ias.MicrosoftAuthCallback;
import ru.vidtu.ias.SharedIAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.Auth;
import ru.vidtu.ias.account.OfflineAccount;
import ru.vidtu.ias.gui.IASAlertScreen;

public class LoginScreen
extends GuiScreen {
    private final GuiScreen prev;
    private final String title;
    private final String buttonText;
    private final String buttonTip;
    private final Consumer<Account> handler;
    private final MicrosoftAuthCallback callback = new MicrosoftAuthCallback();
    private GuiTextField username;
    private GuiButton offline;
    private GuiButton microsoft;
    private String state;

    public LoginScreen(GuiScreen prev, String title, String buttonText, String buttonTip, Consumer<Account> handler) {
        this.prev = prev;
        this.title = title;
        this.buttonText = buttonText;
        this.buttonTip = buttonTip;
        this.handler = handler;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.offline = new GuiButton(0, this.field_146294_l / 2 - 152, this.field_146295_m - 28, 150, 20, this.buttonText);
        this.field_146292_n.add(this.offline);
        this.offline.field_146124_l = false;
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 2, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.username = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 12, 200, 20);
        this.username.func_146203_f(16);
        this.microsoft = new GuiButton(3, this.field_146294_l / 2 - 50, this.field_146295_m / 2 + 12, 100, 20, I18n.func_135052_a((String)"ias.loginGui.microsoft", (Object[])new Object[0]));
        this.field_146292_n.add(this.microsoft);
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.loginOffline();
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.prev);
        } else if (button.field_146127_k == 3) {
            this.loginMicrosoft();
        }
        super.func_146284_a(button);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.username.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mx, int my, float delta) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 5, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"ias.loginGui.nickname", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 22, -1);
        if (this.state != null) {
            this.func_73732_a(this.field_146289_q, this.state, this.field_146294_l / 2, this.field_146295_m / 3 * 2, -26368);
            this.func_73732_a(this.field_146289_q, SharedIAS.LOADING[(int)(System.currentTimeMillis() / 50L % (long)SharedIAS.LOADING.length)], this.field_146294_l / 2, this.field_146295_m / 3 * 2 + 10, -26368);
        }
        this.username.func_146194_f();
        super.func_73863_a(mx, my, delta);
        if (this.offline.func_146115_a()) {
            this.func_146283_a(this.field_146289_q.func_78271_c(this.buttonTip, 150), mx, my);
        }
    }

    public void func_73869_a(char c, int key) throws IOException {
        if (key == 1) {
            this.field_146297_k.func_147108_a(this.prev);
            return;
        }
        if (this.username.func_146201_a(c, key)) {
            return;
        }
        super.func_73869_a(c, key);
    }

    public void func_146281_b() {
        SharedIAS.EXECUTOR.execute(this.callback::close);
        super.func_146281_b();
    }

    public void func_73876_c() {
        this.offline.field_146124_l = !this.username.func_146179_b().trim().isEmpty() && this.state == null;
        this.username.func_146184_c(this.state == null);
        this.microsoft.field_146124_l = this.state == null;
        this.username.func_146178_a();
        super.func_73876_c();
    }

    private void loginMicrosoft() {
        this.state = "";
        SharedIAS.EXECUTOR.execute(() -> {
            this.state = I18n.func_135052_a((String)"ias.loginGui.microsoft.checkBrowser", (Object[])new Object[0]);
            this.openURI("https://login.live.com/oauth20_authorize.srf?client_id=54fd49e4-2103-4044-9603-2b028c814ec3&response_type=code&scope=XboxLive.signin%20XboxLive.offline_access&redirect_uri=http://localhost:59125&prompt=select_account");
            this.callback.start((s, o) -> {
                this.state = I18n.func_135052_a((String)s, (Object[])o);
            }, I18n.func_135052_a((String)"ias.loginGui.microsoft.canClose", (Object[])new Object[0])).whenComplete((acc, t) -> {
                if (this.field_146297_k.field_71462_r != this) {
                    return;
                }
                if (t != null) {
                    this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new IASAlertScreen(() -> this.field_146297_k.func_147108_a(this.prev), EnumChatFormatting.RED + I18n.func_135052_a((String)"ias.error", (Object[])new Object[0]), String.valueOf(t))));
                    return;
                }
                if (acc == null) {
                    this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a(this.prev));
                    return;
                }
                this.field_146297_k.func_152344_a(() -> {
                    this.handler.accept((Account)acc);
                    this.field_146297_k.func_147108_a(this.prev);
                });
            });
        });
    }

    private void loginOffline() {
        this.state = "";
        SharedIAS.EXECUTOR.execute(() -> {
            this.state = I18n.func_135052_a((String)"ias.loginGui.offline.progress", (Object[])new Object[0]);
            OfflineAccount account = new OfflineAccount(this.username.func_146179_b(), Auth.resolveUUID(this.username.func_146179_b()));
            this.field_146297_k.func_152344_a(() -> {
                this.handler.accept(account);
                this.field_146297_k.func_147108_a(this.prev);
            });
        });
    }

    private void openURI(String uri) {
        try {
            Desktop.getDesktop().browse(new URI(uri));
        }
        catch (Throwable t) {
            Sys.openURL((String)uri);
        }
    }
}

