/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Session;
import ru.vidtu.ias.Config;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.gui.IASAlertScreen;
import the_fireplace.ias.IAS;
import the_fireplace.ias.gui.AccountList;
import the_fireplace.ias.gui.LoginScreen;

public class AccountListScreen
extends GuiScreen {
    private static long nextSkinUpdate = System.currentTimeMillis();
    private final GuiScreen prev;
    private AccountList list;
    private GuiButton add;
    private GuiButton login;
    private GuiButton loginOffline;
    private GuiButton delete;
    private GuiButton edit;
    private GuiButton reloadSkins;
    private GuiTextField search;
    private String state;

    public AccountListScreen(GuiScreen prev) {
        this.prev = prev;
    }

    public void func_73866_w_() {
        this.list = new AccountList(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.reloadSkins = new GuiButton(0, 2, 2, 120, 20, I18n.func_135052_a((String)"ias.listGui.reloadSkins", (Object[])new Object[0]));
        this.field_146292_n.add(this.reloadSkins);
        this.search = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 80, 14, 160, 16);
        this.add = new GuiButton(2, this.field_146294_l / 2 + 4 + 40, this.field_146295_m - 52, 120, 20, I18n.func_135052_a((String)"ias.listGui.add", (Object[])new Object[0]));
        this.field_146292_n.add(this.add);
        this.login = new GuiButton(3, this.field_146294_l / 2 - 154 - 10, this.field_146295_m - 52, 120, 20, I18n.func_135052_a((String)"ias.listGui.login", (Object[])new Object[0]));
        this.field_146292_n.add(this.login);
        this.loginOffline = new GuiButton(4, this.field_146294_l / 2 - 154 - 10, this.field_146295_m - 28, 110, 20, I18n.func_135052_a((String)"ias.listGui.loginOffline", (Object[])new Object[0]));
        this.field_146292_n.add(this.loginOffline);
        this.edit = new GuiButton(5, this.field_146294_l / 2 - 40, this.field_146295_m - 52, 80, 20, I18n.func_135052_a((String)"ias.listGui.edit", (Object[])new Object[0]));
        this.field_146292_n.add(this.edit);
        this.delete = new GuiButton(6, this.field_146294_l / 2 - 50, this.field_146295_m - 28, 100, 20, I18n.func_135052_a((String)"ias.listGui.delete", (Object[])new Object[0]));
        this.field_146292_n.add(this.delete);
        this.field_146292_n.add(new GuiButton(7, this.field_146294_l / 2 + 4 + 50, this.field_146295_m - 28, 110, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.updateButtons();
        this.search.func_175207_a(new GuiPageButtonList.GuiResponder(){

            public void func_175321_a(int id, boolean value) {
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175319_a(int id, String value) {
                AccountListScreen.this.list.updateAccounts(value);
            }
        });
        this.list.updateAccounts(this.search.func_146179_b());
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.reloadSkins();
        } else if (button.field_146127_k == 2) {
            this.add();
        } else if (button.field_146127_k == 3) {
            this.login();
        } else if (button.field_146127_k == 4) {
            this.loginOffline();
        } else if (button.field_146127_k == 5) {
            this.edit();
        } else if (button.field_146127_k == 6) {
            this.delete();
        } else if (button.field_146127_k == 7) {
            this.field_146297_k.func_147108_a(this.prev);
        }
        super.func_146284_a(button);
    }

    public void func_73864_a(int mx, int my, int btn) throws IOException {
        if (this.list.func_148179_a(mx, my, btn)) {
            return;
        }
        this.search.func_146192_a(mx, my, btn);
        super.func_73864_a(mx, my, btn);
    }

    public void func_146274_d() throws IOException {
        this.list.func_178039_p();
        super.func_146274_d();
    }

    public void func_73876_c() {
        this.search.func_146178_a();
        this.updateButtons();
    }

    public void func_146281_b() {
        Config.save(this.field_146297_k.field_71412_D.toPath());
    }

    public void func_73863_a(int mx, int my, float delta) {
        this.func_146276_q_();
        this.list.func_148128_a(mx, my, delta);
        this.search.func_146194_f();
        if (this.search.func_146179_b().isEmpty()) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ias.listGui.search", (Object[])new Object[0]), this.search.field_146209_f + 4, this.search.field_146210_g + (this.search.field_146219_i - 8) / 2, -8355712);
        }
        super.func_73863_a(mx, my, delta);
        this.func_73732_a(this.field_146289_q, "In-Game Account Switcher", this.field_146294_l / 2, 4, -1);
        if (this.list.selectedElement() >= 0) {
            this.field_146297_k.func_110434_K().func_110577_a(this.list.entries.get(this.list.selectedElement()).skin());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean slim = this.list.entries.get(this.list.selectedElement()).slimSkin();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
            GlStateManager.func_179137_b((double)1.0, (double)((double)this.field_146295_m / 8.0 - 16.0 - 4.0), (double)0.0);
            GuiScreen.func_146110_a((int)4, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            GuiScreen.func_146110_a((int)4, (int)8, (float)20.0f, (float)20.0f, (int)8, (int)12, (float)64.0f, (float)64.0f);
            GuiScreen.func_146110_a((int)(slim ? 1 : 0), (int)8, (float)44.0f, (float)20.0f, (int)(slim ? 3 : 4), (int)12, (float)64.0f, (float)64.0f);
            GuiScreen.func_146110_a((int)12, (int)8, (float)36.0f, (float)52.0f, (int)(slim ? 3 : 4), (int)12, (float)64.0f, (float)64.0f);
            GuiScreen.func_146110_a((int)4, (int)20, (float)4.0f, (float)20.0f, (int)4, (int)12, (float)64.0f, (float)64.0f);
            GuiScreen.func_146110_a((int)8, (int)20, (float)20.0f, (float)52.0f, (int)4, (int)12, (float)64.0f, (float)64.0f);
            if (this.field_146297_k.field_71474_y.func_178876_d().contains(EnumPlayerModelParts.HAT)) {
                GuiScreen.func_146110_a((int)4, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            }
            if (this.field_146297_k.field_71474_y.func_178876_d().contains(EnumPlayerModelParts.RIGHT_SLEEVE)) {
                GuiScreen.func_146110_a((int)(slim ? 1 : 0), (int)8, (float)44.0f, (float)36.0f, (int)(slim ? 3 : 4), (int)12, (float)64.0f, (float)64.0f);
            }
            if (this.field_146297_k.field_71474_y.func_178876_d().contains(EnumPlayerModelParts.LEFT_SLEEVE)) {
                GuiScreen.func_146110_a((int)12, (int)8, (float)52.0f, (float)52.0f, (int)(slim ? 3 : 4), (int)12, (float)64.0f, (float)64.0f);
            }
            if (this.field_146297_k.field_71474_y.func_178876_d().contains(EnumPlayerModelParts.RIGHT_PANTS_LEG)) {
                GuiScreen.func_146110_a((int)4, (int)20, (float)4.0f, (float)36.0f, (int)4, (int)12, (float)64.0f, (float)64.0f);
            }
            if (this.field_146297_k.field_71474_y.func_178876_d().contains(EnumPlayerModelParts.LEFT_PANTS_LEG)) {
                GuiScreen.func_146110_a((int)8, (int)20, (float)4.0f, (float)52.0f, (int)4, (int)12, (float)64.0f, (float)64.0f);
            }
            GlStateManager.func_179121_F();
        }
        if (this.state != null) {
            this.func_73732_a(this.field_146289_q, this.state, this.field_146294_l / 2, this.field_146295_m - 62, -26368);
        }
    }

    private void reloadSkins() {
        if (this.list.entries.isEmpty() || System.currentTimeMillis() <= nextSkinUpdate || this.state != null) {
            return;
        }
        IAS.SKIN_CACHE.clear();
        this.list.updateAccounts(this.search.func_146179_b());
        nextSkinUpdate = System.currentTimeMillis() + 15000L;
    }

    private void login() {
        if (this.list.selectedElement() < 0 || this.state != null) {
            return;
        }
        Account acc = this.list.entries.get(this.list.selectedElement()).account();
        this.updateButtons();
        this.state = "";
        acc.login((s, o) -> {
            this.state = I18n.func_135052_a((String)s, (Object[])o);
        }).whenComplete((d, t) -> {
            this.state = null;
            if (t != null) {
                this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)new IASAlertScreen(() -> this.field_146297_k.func_147108_a((GuiScreen)this), EnumChatFormatting.RED + I18n.func_135052_a((String)"ias.error", (Object[])new Object[0]), String.valueOf(t))));
                return;
            }
            this.field_146297_k.func_152344_a(() -> {
                this.field_146297_k.field_71449_j = new Session(d.name(), UUIDTypeAdapter.fromUUID((UUID)d.uuid()), d.accessToken(), d.userType());
            });
        });
    }

    private void loginOffline() {
        if (this.list.selectedElement() < 0 || this.state != null) {
            return;
        }
        Account acc = this.list.entries.get(this.list.selectedElement()).account();
        this.field_146297_k.field_71449_j = new Session(acc.name(), UUIDTypeAdapter.fromUUID((UUID)UUID.nameUUIDFromBytes("OfflinePlayer".concat(acc.name()).getBytes(StandardCharsets.UTF_8))), "0", "legacy");
    }

    private void add() {
        if (this.state != null) {
            return;
        }
        this.field_146297_k.func_147108_a((GuiScreen)new LoginScreen(this, I18n.func_135052_a((String)"ias.loginGui.add", (Object[])new Object[0]), I18n.func_135052_a((String)"ias.loginGui.add.button", (Object[])new Object[0]), I18n.func_135052_a((String)"ias.loginGui.add.button.tooltip", (Object[])new Object[0]), acc -> {
            Config.accounts.add((Account)acc);
            Config.save(this.field_146297_k.field_71412_D.toPath());
            this.list.updateAccounts(this.search.func_146179_b());
        }));
    }

    public void edit() {
        if (this.list.selectedElement() < 0 || this.state != null) {
            return;
        }
        Account acc = this.list.entries.get(this.list.selectedElement()).account();
        this.field_146297_k.func_147108_a((GuiScreen)new LoginScreen(this, I18n.func_135052_a((String)"ias.loginGui.edit", (Object[])new Object[0]), I18n.func_135052_a((String)"ias.loginGui.edit.button", (Object[])new Object[0]), I18n.func_135052_a((String)"ias.loginGui.edit.button.tooltip", (Object[])new Object[0]), newAcc -> {
            Config.accounts.set(Config.accounts.indexOf(acc), (Account)newAcc);
            Config.save(this.field_146297_k.field_71412_D.toPath());
        }));
    }

    public void delete() {
        if (this.list.selectedElement() < 0 || this.state != null) {
            return;
        }
        Account acc = this.list.entries.get(this.list.selectedElement()).account();
        if (AccountListScreen.func_146272_n()) {
            Config.accounts.remove(acc);
            Config.save(this.field_146297_k.field_71412_D.toPath());
            this.updateButtons();
            this.list.updateAccounts(this.search.func_146179_b());
            return;
        }
        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((b, id) -> {
            if (b) {
                Config.accounts.remove(acc);
                this.updateButtons();
                this.list.updateAccounts(this.search.func_146179_b());
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }, I18n.func_135052_a((String)"ias.deleteGui.title", (Object[])new Object[0]), I18n.func_135052_a((String)"ias.deleteGui.text", (Object[])new Object[]{acc.name()}), 0));
    }

    private void updateButtons() {
        this.login.field_146124_l = this.list.selectedElement() >= 0 && this.state == null;
        this.loginOffline.field_146124_l = this.list.selectedElement() >= 0;
        this.add.field_146124_l = this.state == null;
        this.edit.field_146124_l = this.list.selectedElement() >= 0 && this.state == null;
        this.delete.field_146124_l = this.list.selectedElement() >= 0 && this.state == null;
        this.reloadSkins.field_146124_l = this.list.selectedElement() >= 0 && this.state == null && System.currentTimeMillis() > nextSkinUpdate;
    }

    public void func_73869_a(char c, int key) throws IOException {
        if (this.search.func_146201_a(c, key)) {
            return;
        }
        if (key == 1) {
            this.field_146297_k.func_147108_a(this.prev);
            return;
        }
        if (key == 63 || key == 19) {
            this.reloadSkins();
            return;
        }
        if (key == 28 || key == 156) {
            if (GuiScreen.func_146272_n()) {
                this.loginOffline();
            } else {
                this.login();
            }
            return;
        }
        if (key == 30 || key == 13 || key == 78) {
            this.add();
            return;
        }
        if (key == 52 || key == 181) {
            this.edit();
            return;
        }
        if (key == 211 || key == 12 || key == 74) {
            this.delete();
            return;
        }
        super.func_73869_a(c, key);
    }
}

