/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.util.ResourceLocation;
import ru.vidtu.ias.Config;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.legacy.SkinLoader;
import the_fireplace.ias.IAS;

public class AccountList
extends GuiListExtended {
    public final List<AccountEntry> entries = new ArrayList<AccountEntry>();

    public AccountList(Minecraft mc, int width, int height) {
        super(mc, width, height, 32, height - 64, 14);
    }

    public void updateAccounts(String query) {
        this.entries.clear();
        Config.accounts.stream().filter(acc -> query.trim().isEmpty() || acc.name().toLowerCase(Locale.ROOT).startsWith(query.toLowerCase(Locale.ROOT))).forEach(acc -> this.entries.add(new AccountEntry((Account)acc)));
        this.field_148168_r = this.entries.isEmpty() ? -1 : 0;
    }

    public void swap(int first, int second) {
        Account account = Config.accounts.get(first);
        Config.accounts.set(first, Config.accounts.get(second));
        Config.accounts.set(second, account);
        Config.save(this.field_148161_k.field_71412_D.toPath());
        AccountEntry entry = this.entries.get(first);
        this.entries.set(first, this.entries.get(second));
        this.entries.set(second, entry);
        this.field_148168_r = second;
    }

    public int func_148127_b() {
        return this.entries.size();
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.entries.get(index);
    }

    public int selectedElement() {
        return this.field_148168_r;
    }

    protected boolean func_148131_a(int slotIndex) {
        return slotIndex == this.field_148168_r;
    }

    public class AccountEntry
    implements GuiListExtended.IGuiListEntry {
        private final Account account;
        private ResourceLocation skin;
        private boolean slimSkin;

        public AccountEntry(Account account) {
            this.account = account;
            if (IAS.SKIN_CACHE.containsKey(account.uuid())) {
                this.skin = IAS.SKIN_CACHE.get(account.uuid());
                return;
            }
            this.skin = DefaultPlayerSkin.func_177334_a((UUID)account.uuid());
            this.slimSkin = DefaultPlayerSkin.func_177332_b((UUID)account.uuid()).equalsIgnoreCase("slim");
            SkinLoader.loadSkin(account.uuid()).thenAccept(en -> {
                if (en == null) {
                    return;
                }
                BufferedImage skinImage = new ImageBufferDownload().func_78432_a((BufferedImage)en.getKey());
                this.slimSkin = (Boolean)en.getValue();
                AccountList.this.field_148161_k.func_152344_a(() -> {
                    this.skin = AccountList.this.field_148161_k.func_110434_K().func_110578_a("ias_skin:" + account.uuid().toString().replace("-", ""), new DynamicTexture(skinImage));
                    IAS.SKIN_CACHE.put(account.uuid(), this.skin);
                });
            });
        }

        public Account account() {
            return this.account;
        }

        public ResourceLocation skin() {
            return this.skin;
        }

        public boolean slimSkin() {
            return this.slimSkin;
        }

        public void func_180790_a(int i, int x, int y, int w, int h, int mx, int my, boolean hover) {
            int color = -1;
            if (AccountList.this.field_148161_k.func_110432_I().func_111285_a().equals(this.account.name())) {
                color = 65280;
            }
            ((AccountList)AccountList.this).field_148161_k.field_71466_p.func_78276_b(this.account.name(), x + 10, y + 1, color);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AccountList.this.field_148161_k.func_110434_K().func_110577_a(this.skin());
            GuiScreen.func_146110_a((int)x, (int)(y + 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            if (((AccountList)AccountList.this).field_148161_k.field_71474_y.func_178876_d().contains(EnumPlayerModelParts.HAT)) {
                GuiScreen.func_146110_a((int)x, (int)(y + 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            }
            if (AccountList.this.field_148168_r == i) {
                boolean movableUp;
                AccountList.this.field_148161_k.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/server_selection.png"));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean movableDown = i + 1 < AccountList.this.entries.size();
                boolean bl = movableUp = i > 0;
                if (movableDown) {
                    boolean hoveredDown = mx > x + w - 16 && mx < x + w - 6 && hover;
                    GuiScreen.func_146110_a((int)(x + w - 35), (int)(y - 18), (float)48.0f, (float)(hoveredDown ? 32.0f : 0.0f), (int)32, (int)32, (float)256.0f, (float)256.0f);
                }
                if (movableUp) {
                    boolean hoveredUp = mx > x + w - (movableDown ? 28 : 16) && mx < x + w - (movableDown ? 16 : 6) && hover;
                    GuiScreen.func_146110_a((int)(x + w - (movableDown ? 30 : 19)), (int)(y - 3), (float)96.0f, (float)(hoveredUp ? 32.0f : 0.0f), (int)32, (int)32, (float)256.0f, (float)256.0f);
                }
            }
        }

        public boolean func_148278_a(int i, int mx, int my, int button, int rx, int ry) {
            if (button == 0 && AccountList.this.field_148168_r == i) {
                boolean movableUp;
                int w = AccountList.this.func_148139_c();
                boolean movableDown = i + 1 < AccountList.this.entries.size();
                boolean bl = movableUp = i > 0;
                if (movableDown) {
                    boolean hoveredDown;
                    boolean bl2 = hoveredDown = rx > w - 16 && rx < w - 6;
                    if (hoveredDown) {
                        AccountList.this.field_148161_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                        AccountList.this.swap(i, i + 1);
                    }
                }
                if (movableUp) {
                    boolean hoveredUp;
                    boolean bl3 = rx > w - (movableDown ? 28 : 16) && rx < w - (movableDown ? 16 : 6) ? true : (hoveredUp = false);
                    if (hoveredUp) {
                        AccountList.this.field_148161_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                        AccountList.this.swap(i, i - 1);
                    }
                }
                return true;
            }
            AccountList.this.field_148168_r = i;
            return true;
        }

        public void func_148277_b(int i, int x, int y, int btn, int rx, int ry) {
        }

        public void func_178011_a(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
        }
    }
}

