/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.legacy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.vidtu.ias.SharedIAS;
import ru.vidtu.ias.account.Auth;

public class SkinLoader {
    @NotNull
    public static @NotNull CompletableFuture< @Nullable Map.Entry<@NotNull BufferedImage, @NotNull Boolean>> loadSkin(@NotNull UUID uuid) {
        CompletableFuture<Map.Entry<BufferedImage, Boolean>> cf = new CompletableFuture<Map.Entry<BufferedImage, Boolean>>();
        SharedIAS.EXECUTOR.execute(() -> {
            try {
                HttpsURLConnection conn = (HttpsURLConnection)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid).openConnection();
                if (Auth.FIXED_CONTEXT != null) {
                    conn.setSSLSocketFactory(Auth.FIXED_CONTEXT.getSocketFactory());
                }
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(15000);
                if (conn.getResponseCode() < 200 || conn.getResponseCode() > 299) {
                    try {
                        BufferedReader err = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new IllegalArgumentException("loadSkin response: " + conn.getResponseCode() + ", data: " + err.lines().collect(Collectors.joining("\n")));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (err != null) {
                                if (throwable != null) {
                                    try {
                                        err.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    err.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable t) {
                        throw new IllegalArgumentException("loadSkin response: " + conn.getResponseCode(), t);
                    }
                }
                try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    JsonObject resp = (JsonObject)SharedIAS.GSON.fromJson(in.lines().collect(Collectors.joining("\n")), JsonObject.class);
                    JsonObject json = StreamSupport.stream(resp.getAsJsonArray("properties").spliterator(), false).map(JsonElement::getAsJsonObject).filter(jo -> jo.get("name").getAsString().equalsIgnoreCase("textures")).findAny().map(jo -> (JsonObject)SharedIAS.GSON.fromJson(new String(Base64.getDecoder().decode(jo.get("value").getAsString()), StandardCharsets.UTF_8), JsonObject.class)).orElse(null);
                    if (json == null || !json.has("textures") || !json.getAsJsonObject("textures").has("SKIN")) {
                        cf.complete(null);
                        return;
                    }
                    JsonObject skin = json.getAsJsonObject("textures").getAsJsonObject("SKIN");
                    cf.complete(new AbstractMap.SimpleImmutableEntry<BufferedImage, Boolean>(ImageIO.read(new URL(skin.get("url").getAsString())), skin.has("metadata") && skin.getAsJsonObject("metadata").has("model") && skin.getAsJsonObject("metadata").get("model").getAsString().equalsIgnoreCase("slim")));
                }
            }
            catch (Throwable t) {
                SharedIAS.LOG.warn("Unable to load skin for: " + uuid, t);
            }
        });
        return cf;
    }
}

