/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias.account;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import ru.vidtu.ias.SharedIAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.Auth;

public class MicrosoftAccount
implements Account {
    private String name;
    private String accessToken;
    private String refreshToken;
    private UUID uuid;

    public MicrosoftAccount(@NotNull String name, @NotNull String accessToken, @NotNull String refreshToken, @NotNull UUID uuid) {
        this.name = name;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.uuid = uuid;
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Contract(pure=true)
    @NotNull
    public String accessToken() {
        return this.accessToken;
    }

    @Contract(pure=true)
    public String refreshToken() {
        return this.refreshToken;
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Account.AuthData> login(@NotNull @NotNull BiConsumer<@NotNull String, @NotNull Object[]> progressHandler) {
        CompletableFuture<Account.AuthData> cf = new CompletableFuture<Account.AuthData>();
        SharedIAS.EXECUTOR.execute(() -> {
            try {
                this.refresh(progressHandler);
                cf.complete(new Account.AuthData(this.name, this.uuid, this.accessToken, "msa"));
            }
            catch (Throwable t) {
                SharedIAS.LOG.error("Unable to login/refresh Microsoft account.", t);
                cf.completeExceptionally(t);
            }
        });
        return cf;
    }

    private void refresh(@NotNull @NotNull BiConsumer<@NotNull String, @NotNull Object[]> progressHandler) throws Exception {
        try {
            SharedIAS.LOG.info("Refreshing...");
            progressHandler.accept("ias.loginGui.microsoft.progress", new Object[]{"getProfile"});
            Map.Entry<UUID, String> profile = Auth.getProfile(this.accessToken);
            SharedIAS.LOG.info("Access token is valid.");
            this.uuid = profile.getKey();
            this.name = profile.getValue();
        }
        catch (Exception e) {
            try {
                SharedIAS.LOG.info("Step: refreshToken.");
                progressHandler.accept("ias.loginGui.microsoft.progress", new Object[]{"refreshToken"});
                Map.Entry<String, String> authRefreshTokens = Auth.refreshToken(this.refreshToken);
                String refreshToken = authRefreshTokens.getValue();
                SharedIAS.LOG.info("Step: authXBL.");
                progressHandler.accept("ias.loginGui.microsoft.progress", new Object[]{"authXBL"});
                String xblToken = Auth.authXBL(authRefreshTokens.getKey());
                SharedIAS.LOG.info("Step: authXSTS.");
                progressHandler.accept("ias.loginGui.microsoft.progress", new Object[]{"authXSTS"});
                Map.Entry<String, String> xstsTokenUserhash = Auth.authXSTS(xblToken);
                SharedIAS.LOG.info("Step: authMinecraft.");
                progressHandler.accept("ias.loginGui.microsoft.progress", new Object[]{"authMinecraft"});
                String accessToken = Auth.authMinecraft(xstsTokenUserhash.getValue(), xstsTokenUserhash.getKey());
                SharedIAS.LOG.info("Step: getProfile.");
                progressHandler.accept("ias.loginGui.microsoft.progress", new Object[]{"getProfile"});
                Map.Entry<UUID, String> profile = Auth.getProfile(accessToken);
                SharedIAS.LOG.info("Refreshed.");
                this.uuid = profile.getKey();
                this.name = profile.getValue();
                this.accessToken = accessToken;
                this.refreshToken = refreshToken;
            }
            catch (Exception ex) {
                ex.addSuppressed(e);
                throw ex;
            }
        }
    }
}

