/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias;

import java.util.Locale;
import org.jetbrains.annotations.Contract;

public class Expression {
    private final String expression;
    private int position;

    public Expression(String expression) {
        this.expression = expression.replaceAll("\\s+", "");
    }

    @Contract(pure=true)
    private char current() {
        return this.position >= this.expression.length() ? (char)'?' : this.expression.charAt(this.position);
    }

    public double parse() {
        return this.parse(0);
    }

    private double parse(int returnFlag) {
        try {
            if (returnFlag == 2) {
                if (this.current() == '-') {
                    ++this.position;
                    return -this.parse(2);
                }
                if (this.current() == '(') {
                    ++this.position;
                    double x = this.parse(0);
                    if (this.current() == ')') {
                        ++this.position;
                    }
                    if (this.current() == '^') {
                        ++this.position;
                        x = Math.pow(x, this.parse(2));
                    }
                    return x;
                }
                int begin = this.position;
                while (this.current() == '.' || Character.isDigit(this.current())) {
                    ++this.position;
                }
                double x = Double.parseDouble(this.expression.substring(begin, this.position));
                if (this.current() == '^') {
                    ++this.position;
                    x = Math.pow(x, this.parse(2));
                }
                return x;
            }
            double x = this.parse(2);
            while (true) {
                if (this.current() == '*') {
                    ++this.position;
                    x *= this.parse(2);
                    continue;
                }
                if (this.current() != '/') break;
                ++this.position;
                x /= this.parse(2);
            }
            if (returnFlag == 1) {
                return x;
            }
            while (true) {
                if (this.current() == '+') {
                    ++this.position;
                    x += this.parse(1);
                    continue;
                }
                if (this.current() != '-') break;
                ++this.position;
                x -= this.parse(1);
            }
            return x;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Sorry, but we're unable to calculate " + this.expression + " at pos " + this.position, t);
        }
    }

    @Contract(pure=true)
    public static double parseWidthHeight(String expression, int width, int height) throws IllegalArgumentException {
        return new Expression(expression.toLowerCase(Locale.ROOT).replace("w", String.valueOf(width)).replace("h", String.valueOf(height))).parse();
    }
}

