/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ias;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.vidtu.ias.SharedIAS;
import ru.vidtu.ias.account.Account;
import ru.vidtu.ias.account.Auth;
import ru.vidtu.ias.account.MicrosoftAccount;
import ru.vidtu.ias.account.OfflineAccount;

public class Config {
    private static final int CONFIG_VERSION = 2;
    public static List<Account> accounts = new ArrayList<Account>();
    public static boolean titleScreenText = true;
    public static String titleScreenTextX;
    public static String titleScreenTextY;
    public static Alignment titleScreenTextAlignment;
    public static boolean titleScreenButton;
    public static String titleScreenButtonX;
    public static String titleScreenButtonY;
    public static boolean multiplayerScreenButton;
    public static String multiplayerScreenButtonX;
    public static String multiplayerScreenButtonY;
    public static boolean experimentalJavaFXBrowser;

    public static void load(@NotNull Path gameDir) {
        try {
            Path p = gameDir.resolve("config").resolve("ias.json");
            if (!Files.isRegularFile(p, new LinkOption[0])) {
                return;
            }
            JsonObject jo = (JsonObject)SharedIAS.GSON.fromJson(new String(Files.readAllBytes(p), StandardCharsets.UTF_8), JsonObject.class);
            if (!jo.has("version")) {
                accounts = jo.has("accounts") ? Config.loadAccounts(jo.getAsJsonArray("accounts"), 1) : new ArrayList<Account>();
                titleScreenTextX = jo.has("textX") ? jo.get("textX").getAsString() : null;
                titleScreenTextX = jo.has("textY") ? jo.get("textY").getAsString() : null;
                titleScreenButtonX = jo.has("btnX") ? jo.get("btnX").getAsString() : null;
                titleScreenButtonY = jo.has("btnY") ? jo.get("btnY").getAsString() : null;
                multiplayerScreenButton = jo.has("showOnMPScreen") && jo.get("showOnMPScreen").getAsBoolean();
                titleScreenButton = !jo.has("showOnTitleScreen") || jo.get("showOnTitleScreen").getAsBoolean();
                return;
            }
            int version = jo.get("version").getAsInt();
            if (version != 2) {
                throw new IllegalStateException("Unknown config version: " + version + ", content: " + jo);
            }
            accounts = jo.has("accounts") ? Config.loadAccounts(jo.getAsJsonArray("accounts"), version) : new ArrayList<Account>();
            titleScreenText = !jo.has("titleScreenText") || jo.get("titleScreenText").getAsBoolean();
            titleScreenTextX = jo.has("titleScreenTextX") ? jo.get("titleScreenTextX").getAsString() : null;
            titleScreenTextY = jo.has("titleScreenTextY") ? jo.get("titleScreenTextY").getAsString() : null;
            titleScreenTextAlignment = jo.has("titleScreenTextAlignment") ? Alignment.getOr(jo.get("titleScreenTextAlignment").getAsString(), Alignment.CENTER) : Alignment.CENTER;
            titleScreenButton = !jo.has("titleScreenButton") || jo.get("titleScreenButton").getAsBoolean();
            titleScreenButtonX = jo.has("titleScreenButtonX") ? jo.get("titleScreenButtonX").getAsString() : null;
            titleScreenButtonY = jo.has("titleScreenButtonY") ? jo.get("titleScreenButtonY").getAsString() : null;
            multiplayerScreenButton = jo.has("multiplayerScreenButton") && jo.get("multiplayerScreenButton").getAsBoolean();
            multiplayerScreenButtonX = jo.has("multiplayerScreenButtonX") ? jo.get("multiplayerScreenButtonX").getAsString() : null;
            multiplayerScreenButtonY = jo.has("multiplayerScreenButtonY") ? jo.get("multiplayerScreenButtonY").getAsString() : null;
            experimentalJavaFXBrowser = jo.has("experimentalJavaFXBrowser") && jo.get("experimentalJavaFXBrowser").getAsBoolean() && Config.experimentalJavaFXBrowserAvailable();
        }
        catch (Throwable t) {
            SharedIAS.LOG.error("Unable to load IAS config.", t);
        }
    }

    @Contract(pure=true)
    @NotNull
    private static @NotNull List<@NotNull Account> loadAccounts(@NotNull JsonArray accounts, int version) {
        ArrayList<Account> accs = new ArrayList<Account>();
        for (JsonElement je : accounts) {
            Account account = Config.loadAccount(je.getAsJsonObject().get("type").getAsString(), version == 1 ? je.getAsJsonObject().getAsJsonObject("data") : je.getAsJsonObject(), version);
            if (account == null) continue;
            accs.add(account);
        }
        return accs;
    }

    @Contract(pure=true)
    @Nullable
    private static Account loadAccount(@NotNull String type, @NotNull JsonObject json, int version) {
        if (type.equalsIgnoreCase("ias:microsoft") || type.equalsIgnoreCase("ru.vidtu.ias.account.MicrosoftAccount")) {
            return new MicrosoftAccount(version == 1 ? json.get("username").getAsString() : json.get("name").getAsString(), json.get("accessToken").getAsString(), json.get("refreshToken").getAsString(), UUID.fromString(json.get("uuid").getAsString()));
        }
        if (type.equalsIgnoreCase("ias:offline") || type.equalsIgnoreCase("ru.vidtu.ias.account.OfflineAccount")) {
            String name = version == 1 ? json.get("username").getAsString() : json.get("name").getAsString();
            return new OfflineAccount(name, version == 1 ? Auth.resolveUUID(name) : UUID.fromString(json.get("uuid").getAsString()));
        }
        return null;
    }

    public static void save(@NotNull Path gameDir) {
        try {
            Path p = gameDir.resolve("config").resolve("ias.json");
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            JsonObject jo = new JsonObject();
            jo.addProperty("version", (Number)2);
            jo.add("accounts", (JsonElement)Config.saveAccounts(accounts));
            jo.addProperty("titleScreenText", Boolean.valueOf(titleScreenText));
            if (titleScreenTextX != null) {
                jo.addProperty("titleScreenTextX", titleScreenTextX);
            }
            if (titleScreenTextY != null) {
                jo.addProperty("titleScreenTextY", titleScreenTextY);
            }
            if (titleScreenTextAlignment != null) {
                jo.addProperty("titleScreenTextAlignment", titleScreenTextAlignment.name());
            }
            jo.addProperty("titleScreenButton", Boolean.valueOf(titleScreenButton));
            if (titleScreenButtonX != null) {
                jo.addProperty("titleScreenButtonX", titleScreenButtonX);
            }
            if (titleScreenButtonY != null) {
                jo.addProperty("titleScreenButtonY", titleScreenButtonY);
            }
            jo.addProperty("multiplayerScreenButton", Boolean.valueOf(multiplayerScreenButton));
            if (multiplayerScreenButtonX != null) {
                jo.addProperty("multiplayerScreenButtonX", multiplayerScreenButtonX);
            }
            if (multiplayerScreenButtonY != null) {
                jo.addProperty("multiplayerScreenButtonY", multiplayerScreenButtonY);
            }
            jo.addProperty("experimentalJavaFXBrowser", Boolean.valueOf(experimentalJavaFXBrowser));
            Files.write(p, jo.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Throwable t) {
            SharedIAS.LOG.error("Unable to save IAS config.", t);
        }
    }

    @Contract(pure=true)
    @NotNull
    private static JsonArray saveAccounts(@NotNull @NotNull List<@NotNull Account> accounts) {
        JsonArray ja = new JsonArray();
        for (Account a : accounts) {
            JsonObject jo = Config.saveAccount(a);
            if (jo == null) continue;
            ja.add((JsonElement)jo);
        }
        return ja;
    }

    @Contract(pure=true)
    @Nullable
    private static JsonObject saveAccount(@NotNull Account account) {
        if (account instanceof MicrosoftAccount) {
            JsonObject jo = new JsonObject();
            MicrosoftAccount ma = (MicrosoftAccount)account;
            jo.addProperty("type", "ias:microsoft");
            jo.addProperty("name", ma.name());
            jo.addProperty("accessToken", ma.accessToken());
            jo.addProperty("refreshToken", ma.refreshToken());
            jo.addProperty("uuid", ma.uuid().toString());
            return jo;
        }
        if (account instanceof OfflineAccount) {
            JsonObject jo = new JsonObject();
            jo.addProperty("type", "ias:offline");
            jo.addProperty("name", account.name());
            jo.addProperty("uuid", account.uuid().toString());
            return jo;
        }
        return null;
    }

    public static boolean experimentalJavaFXBrowserAvailable() {
        try {
            Class.forName("javafx.scene.web.WebView");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        titleScreenTextAlignment = Alignment.CENTER;
        titleScreenButton = true;
        multiplayerScreenButton = false;
        experimentalJavaFXBrowser = false;
    }

    public static enum Alignment {
        LEFT("ias.configGui.titleScreenText.alignment.left"),
        CENTER("ias.configGui.titleScreenText.alignment.center"),
        RIGHT("ias.configGui.titleScreenText.alignment.right");

        private final String key;

        private Alignment(String key) {
            this.key = key;
        }

        @Contract(pure=true)
        @NotNull
        public String key() {
            return this.key;
        }

        @Contract(pure=true)
        @NotNull
        public static Alignment getOr(@NotNull String name, @NotNull Alignment fallback) {
            for (Alignment v : Alignment.values()) {
                if (!v.name().equalsIgnoreCase(name)) continue;
                return v;
            }
            return fallback;
        }
    }
}

