/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.utils;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class WaypointUtils {
    private static final ResourceLocation beaconBeam = new ResourceLocation("textures/entity/beacon_beam.png");

    public static void renderBeaconBeam(double x, double y, double z, int rgb, float alphaMultiplier, float partialTicks) {
        int height = 300;
        int bottomOffset = 0;
        int topOffset = bottomOffset + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(beaconBeam);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        double time = (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() + (double)partialTicks;
        double d1 = MathHelper.func_181162_h((double)(-time * 0.2 - (double)MathHelper.func_76128_c((double)(-time * 0.1))));
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        double d2 = time * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d2 + 2.356194490192345) * 0.2;
        double d5 = 0.5 + Math.sin(d2 + 2.356194490192345) * 0.2;
        double d6 = 0.5 + Math.cos(d2 + 0.7853981633974483) * 0.2;
        double d7 = 0.5 + Math.sin(d2 + 0.7853981633974483) * 0.2;
        double d8 = 0.5 + Math.cos(d2 + 3.9269908169872414) * 0.2;
        double d9 = 0.5 + Math.sin(d2 + 3.9269908169872414) * 0.2;
        double d10 = 0.5 + Math.cos(d2 + 5.497787143782138) * 0.2;
        double d11 = 0.5 + Math.sin(d2 + 5.497787143782138) * 0.2;
        double d14 = -1.0 + d1;
        double d15 = (double)height * 2.5 + d14;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)topOffset, z + d7).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + d6, y + (double)bottomOffset, z + d7).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)bottomOffset, z + d11).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d10, y + (double)topOffset, z + d11).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)topOffset, z + d9).func_181673_a(1.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + d8, y + (double)bottomOffset, z + d9).func_181673_a(1.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)bottomOffset, z + d5).func_181673_a(0.0, d14).func_181666_a(r, g, b, 1.0f).func_181675_d();
        worldrenderer.func_181662_b(x + d4, y + (double)topOffset, z + d5).func_181673_a(0.0, d15).func_181666_a(r, g, b, alphaMultiplier).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179129_p();
        double d12 = -1.0 + d1;
        double d13 = (double)height + d12;
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.2).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.2).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)bottomOffset, z + 0.8).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.8, y + (double)topOffset, z + 0.8).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.8).func_181673_a(1.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.8).func_181673_a(1.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)bottomOffset, z + 0.2).func_181673_a(0.0, d12).func_181666_a(r, g, b, 0.25f).func_181675_d();
        worldrenderer.func_181662_b(x + 0.2, y + (double)topOffset, z + 0.2).func_181673_a(0.0, d13).func_181666_a(r, g, b, 0.25f * alphaMultiplier).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawFilledBoundingBox(AxisAlignedBB aabb, Color c, float alphaMultiplier) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)((float)c.getAlpha() / 255.0f * alphaMultiplier));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.8f), (float)((float)c.getGreen() / 255.0f * 0.8f), (float)((float)c.getBlue() / 255.0f * 0.8f), (float)((float)c.getAlpha() / 255.0f * alphaMultiplier));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f * 0.9f), (float)((float)c.getGreen() / 255.0f * 0.9f), (float)((float)c.getBlue() / 255.0f * 0.9f), (float)((float)c.getAlpha() / 255.0f * alphaMultiplier));
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldrenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderWaypointText(String str, BlockPos loc, float partialTicks) {
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179094_E();
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        double x = (double)loc.func_177958_n() + 0.5 - viewerX;
        double y = (double)loc.func_177956_o() - viewerY - (double)viewer.func_70047_e();
        double z = (double)loc.func_177952_p() + 0.5 - viewerZ;
        double distSq = x * x + y * y + z * z;
        double dist = Math.sqrt(distSq);
        if (distSq > 144.0) {
            x *= 12.0 / dist;
            y *= 12.0 / dist;
            z *= 12.0 / dist;
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179109_b((float)0.0f, (float)viewer.func_70047_e(), (float)0.0f);
        WaypointUtils.drawNametag(str);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        WaypointUtils.drawNametag(EnumChatFormatting.YELLOW.toString() + Math.round(dist) + "m");
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
    }

    public static void drawNametag(String str) {
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        int i = 0;
        int j = fontrenderer.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        worldrenderer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, 0x20FFFFFF);
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(str, -fontrenderer.func_78256_a(str) / 2, i, -1);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

