/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.handlers;

import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.DungeonManager;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.Waypoints;
import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;
    private static final String file = "config/DungeonRooms.cfg";

    public static void init() {
        config = new Configuration(new File(file));
        try {
            config.load();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    public static int getInt(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                int n = config.get(category, key, 0).getInt();
                return n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getDouble(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                double d = config.get(category, key, 0.0).getDouble();
                return d;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return 0.0;
    }

    public static String getString(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                String string = config.get(category, key, "").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return "";
    }

    public static boolean getBoolean(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.getCategory(category).containsKey(key)) {
                boolean bl = config.get(category, key, false).getBoolean();
                return bl;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIntConfig(String category, String key, int value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            int set = config.get(category, key, value).getInt();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDoubleConfig(String category, String key, double value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            double set = config.get(category, key, value).getDouble();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringConfig(String category, String key, String value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            String set = config.get(category, key, value).getString();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBooleanConfig(String category, String key, boolean value) {
        config = new Configuration(new File(file));
        try {
            config.load();
            boolean set = config.get(category, key, value).getBoolean();
            config.getCategory(category).get(key).set(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    public static boolean hasKey(String category, String key) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (!config.hasCategory(category)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = config.getCategory(category).containsKey(key);
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
        return false;
    }

    public static void deleteCategory(String category) {
        config = new Configuration(new File(file));
        try {
            config.load();
            if (config.hasCategory(category)) {
                config.removeCategory(new ConfigCategory(category));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    public static void reloadConfig() {
        if (!ConfigHandler.hasKey("toggles", "guiToggled")) {
            ConfigHandler.writeBooleanConfig("toggles", "guiToggled", true);
        }
        if (!ConfigHandler.hasKey("toggles", "motdToggled")) {
            ConfigHandler.writeBooleanConfig("toggles", "motdToggled", true);
        }
        if (!ConfigHandler.hasKey("toggles", "waypointsToggled")) {
            ConfigHandler.writeBooleanConfig("toggles", "waypointsToggled", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showEntrance")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showEntrance", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showSuperboom")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showSuperboom", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showSecrets")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showSecrets", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showFairySouls")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showFairySouls", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showStonk")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showStonk", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "sneakToDisable")) {
            ConfigHandler.writeBooleanConfig("waypoint", "sneakToDisable", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "disableWhenAllFound")) {
            ConfigHandler.writeBooleanConfig("waypoint", "disableWhenAllFound", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showWaypointText")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showWaypointText", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showBoundingBox")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showBoundingBox", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "showBeacon")) {
            ConfigHandler.writeBooleanConfig("waypoint", "showBeacon", true);
        }
        if (!ConfigHandler.hasKey("waypoint", "practiceModeOn")) {
            ConfigHandler.writeBooleanConfig("waypoint", "practiceModeOn", false);
        }
        if (!ConfigHandler.hasKey("gui", "scaleX")) {
            ConfigHandler.writeIntConfig("gui", "scaleX", 50);
        }
        if (!ConfigHandler.hasKey("gui", "scaleY")) {
            ConfigHandler.writeIntConfig("gui", "scaleY", 5);
        }
        if (!ConfigHandler.hasKey("gui", "hotkeyOpen")) {
            ConfigHandler.writeStringConfig("gui", "hotkeyOpen", "gui");
        }
        if (!ConfigHandler.hasKey("drm", "version")) {
            ConfigHandler.writeStringConfig("drm", "version", "3.4.1");
            DungeonRooms.firstLogin = true;
        } else if (!ConfigHandler.getString("drm", "version").equals("3.4.1")) {
            ConfigHandler.writeStringConfig("drm", "version", "3.4.1");
        }
        DungeonManager.guiToggled = ConfigHandler.getBoolean("toggles", "guiToggled");
        DungeonManager.motdToggled = ConfigHandler.getBoolean("toggles", "motdToggled");
        Waypoints.enabled = ConfigHandler.getBoolean("toggles", "waypointsToggled");
        Waypoints.showEntrance = ConfigHandler.getBoolean("waypoint", "showEntrance");
        Waypoints.showSuperboom = ConfigHandler.getBoolean("waypoint", "showSuperboom");
        Waypoints.showSecrets = ConfigHandler.getBoolean("waypoint", "showSecrets");
        Waypoints.showFairySouls = ConfigHandler.getBoolean("waypoint", "showFairySouls");
        Waypoints.showStonk = ConfigHandler.getBoolean("waypoint", "showStonk");
        Waypoints.sneakToDisable = ConfigHandler.getBoolean("waypoint", "sneakToDisable");
        Waypoints.disableWhenAllFound = ConfigHandler.getBoolean("waypoint", "disableWhenAllFound");
        Waypoints.showWaypointText = ConfigHandler.getBoolean("waypoint", "showWaypointText");
        Waypoints.showBoundingBox = ConfigHandler.getBoolean("waypoint", "showBoundingBox");
        Waypoints.showBeacon = ConfigHandler.getBoolean("waypoint", "showBeacon");
        Waypoints.practiceModeOn = ConfigHandler.getBoolean("waypoint", "practiceModeOn");
        DungeonRooms.textLocX = ConfigHandler.getInt("gui", "scaleX");
        DungeonRooms.textLocY = ConfigHandler.getInt("gui", "scaleY");
        DungeonRooms.imageHotkeyOpen = ConfigHandler.getString("gui", "hotkeyOpen");
    }
}

