/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.commands;

import com.google.gson.JsonObject;
import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.DungeonManager;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.RoomDetection;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.Waypoints;
import io.github.quantizr.dungeonrooms.gui.WaypointsGUI;
import io.github.quantizr.dungeonrooms.handlers.ConfigHandler;
import io.github.quantizr.dungeonrooms.handlers.OpenLink;
import io.github.quantizr.dungeonrooms.utils.MapUtils;
import io.github.quantizr.dungeonrooms.utils.Utils;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;

public class RoomCommand
extends CommandBase {
    public String func_71517_b() {
        return "room";
    }

    public String func_71518_a(ICommandSender arg0) {
        return "/" + this.func_71517_b();
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("drm");
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return RoomCommand.func_71530_a((String[])args, (String[])new String[]{"help", "waypoints", "move", "toggle", "set", "discord"});
        }
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("toggle")) {
                return RoomCommand.func_71530_a((String[])args, (String[])new String[]{"help", "gui", "waypointtext", "waypointboundingbox", "waypointbeacon"});
            }
            if (args[0].equalsIgnoreCase("set")) {
                return RoomCommand.func_71530_a((String[])args, (String[])new String[]{"gui", "dsg", "sbp"});
            }
        }
        return null;
    }

    public void func_71515_b(ICommandSender arg0, String[] arg1) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayer player = (EntityPlayer)arg0;
        if (arg1.length < 1) {
            if (!Utils.inCatacombs) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Use this command in dungeons or run \"/room help\" for additional options"));
            } else if (DungeonManager.gameStage == 2) {
                for (String line : DungeonRooms.textToDisplay) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(line));
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Dungeon Rooms: You can also run \"/room help\" for additional options"));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Use this command while clearing rooms or run \"/room help\" for additional options"));
            }
        } else {
            block21 : switch (arg1[0].toLowerCase()) {
                case "help": {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\n" + EnumChatFormatting.GOLD + "Dungeon Rooms Mod Version " + "3.4.1" + "\n" + EnumChatFormatting.DARK_PURPLE + "Hotkeys: (Configurable in Controls Menu)\n" + EnumChatFormatting.AQUA + " " + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[1].func_151463_i()) + EnumChatFormatting.WHITE + " - Opens Secret Waypoints configuration GUI\n" + EnumChatFormatting.AQUA + " " + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[0].func_151463_i()) + EnumChatFormatting.WHITE + " - (old) Opens images of secret locations\n" + EnumChatFormatting.AQUA + " " + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[2].func_151463_i()) + EnumChatFormatting.WHITE + " - View waypoints in Practice Mode (\"/room toggle practice\")\n" + EnumChatFormatting.DARK_PURPLE + "Commands:\n" + EnumChatFormatting.AQUA + " /room" + EnumChatFormatting.WHITE + " - Tells you in chat what room you are standing in.\n" + EnumChatFormatting.AQUA + " /room help" + EnumChatFormatting.WHITE + " - Displays this message.\n" + EnumChatFormatting.AQUA + " /room waypoints" + EnumChatFormatting.WHITE + " - Opens Secret Waypoints config GUI, alternatively can be opened with hotkey\n" + EnumChatFormatting.AQUA + " /room move <x> <y>" + EnumChatFormatting.WHITE + " - Moves the GUI room name text to a coordinate. <x> and <y> are numbers between 0 and 100. Default is 50 for <x> and 5 for <y>.\n" + EnumChatFormatting.AQUA + " /room toggle [argument]" + EnumChatFormatting.WHITE + " - Run \"/room toggle help\" for full list of toggles.\n" + EnumChatFormatting.AQUA + " /room set <gui | dsg | sbp>" + EnumChatFormatting.WHITE + " - Configure whether the hotkey opens the selector GUI or directly goes to DSG/SBP.\n" + EnumChatFormatting.AQUA + " /room discord" + EnumChatFormatting.WHITE + " - Opens the Discord invite for this mod in your browser.\n"));
                    break;
                }
                case "gui": 
                case "open": {
                    if (!Utils.inCatacombs) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Use this command in dungeons"));
                        return;
                    }
                    OpenLink.checkForLink("gui");
                    break;
                }
                case "dsg": {
                    if (!Utils.inCatacombs) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Use this command in dungeons"));
                        return;
                    }
                    OpenLink.checkForLink("dsg");
                    break;
                }
                case "sbp": {
                    if (!Utils.inCatacombs) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Use this command in dungeons"));
                        return;
                    }
                    OpenLink.checkForLink("sbp");
                    break;
                }
                case "set": {
                    switch (arg1[1].toLowerCase()) {
                        case "gui": {
                            DungeonRooms.imageHotkeyOpen = "gui";
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Hotkey has been set to open: GUI"));
                            ConfigHandler.writeStringConfig("gui", "hotkeyOpen", "gui");
                            break block21;
                        }
                        case "dsg": {
                            DungeonRooms.imageHotkeyOpen = "dsg";
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Hotkey has been set to open: DSG"));
                            ConfigHandler.writeStringConfig("gui", "hotkeyOpen", "dsg");
                            break block21;
                        }
                        case "sbp": {
                            DungeonRooms.imageHotkeyOpen = "sbp";
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Hotkey has been set to open: SBP"));
                            ConfigHandler.writeStringConfig("gui", "hotkeyOpen", "sbp");
                            break block21;
                        }
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Valid options are <gui | dsg | sbp>"));
                    break;
                }
                case "wp": 
                case "waypoint": 
                case "waypoints": {
                    new Thread(() -> mc.func_152344_a(() -> mc.func_147108_a((GuiScreen)new WaypointsGUI()))).start();
                    break;
                }
                case "move": {
                    DungeonRooms.textLocX = Integer.parseInt(arg1[1]);
                    DungeonRooms.textLocY = Integer.parseInt(arg1[2]);
                    ConfigHandler.writeIntConfig("gui", "scaleX", DungeonRooms.textLocX);
                    ConfigHandler.writeIntConfig("gui", "scaleY", DungeonRooms.textLocY);
                    player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Room GUI has been moved to " + arg1[1] + ", " + arg1[2]));
                    break;
                }
                case "toggle": {
                    String toggleHelp = "\n" + EnumChatFormatting.GOLD + " Dungeon Rooms Mod Toggle Commands:\n" + EnumChatFormatting.AQUA + " /room toggle gui" + EnumChatFormatting.WHITE + " - Toggles displaying current room in gui.\n" + EnumChatFormatting.AQUA + " /room toggle motd" + EnumChatFormatting.WHITE + " - Toggles displaying the Welcome/MOTD message at the start of a dungeon run.\n" + EnumChatFormatting.AQUA + " /room toggle practice" + EnumChatFormatting.WHITE + " - Toggles Practice Mode, where waypoints are only displayed when holding down " + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[2].func_151463_i()) + "\".\n" + EnumChatFormatting.AQUA + " /room toggle waypoints" + EnumChatFormatting.WHITE + " - Toggles Waypoints, does the same thing as pressing \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[1].func_151463_i()) + "\" then clicking \"Waypoints\".\n" + EnumChatFormatting.AQUA + " /room toggle waypointtext" + EnumChatFormatting.WHITE + " - Toggles displaying waypoint names above waypoints.\n" + EnumChatFormatting.AQUA + " /room toggle waypointboundingbox" + EnumChatFormatting.WHITE + " - Toggles displaying the bounding box on waypoints.\n" + EnumChatFormatting.AQUA + " /room toggle waypointbeacon" + EnumChatFormatting.WHITE + " - Toggles displaying the beacon above waypoints.\n";
                    if (arg1.length == 1) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(toggleHelp));
                        break;
                    }
                    switch (arg1[1].toLowerCase()) {
                        case "gui": {
                            DungeonManager.guiToggled = !DungeonManager.guiToggled;
                            ConfigHandler.writeBooleanConfig("toggles", "guiToggled", DungeonManager.guiToggled);
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Display room names in GUI has been set to: " + DungeonManager.guiToggled));
                            break block21;
                        }
                        case "welcome": 
                        case "motd": {
                            DungeonManager.motdToggled = !DungeonManager.motdToggled;
                            ConfigHandler.writeBooleanConfig("toggles", "motdToggled", DungeonManager.motdToggled);
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Display Welcome/MOTD has been set to: " + DungeonManager.motdToggled));
                            break block21;
                        }
                        case "practice": 
                        case "practicemode": {
                            Waypoints.practiceModeOn = !Waypoints.practiceModeOn;
                            ConfigHandler.writeBooleanConfig("waypoint", "practiceModeOn", Waypoints.practiceModeOn);
                            if (Waypoints.practiceModeOn) {
                                player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7eDungeon Rooms: Practice Mode has been enabled.\n\u00a7e Waypoints will only show up while you are pressing \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[2].func_151463_i()) + "\".\n\u00a7r (Hotkey is configurable in Minecraft Controls menu)"));
                                break block21;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7eDungeon Rooms: Practice Mode has been disabled."));
                            break block21;
                        }
                        case "waypoint": 
                        case "waypoints": {
                            Waypoints.enabled = !Waypoints.enabled;
                            ConfigHandler.writeBooleanConfig("waypoint", "waypointsToggled", Waypoints.enabled);
                            if (Waypoints.enabled) {
                                player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7eDungeon Rooms: Waypoints will now automatically show up when you enter a new dungeon room."));
                                break block21;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7eDungeon Rooms: Waypoints have been disabled."));
                            break block21;
                        }
                        case "text": 
                        case "waypointtext": {
                            Waypoints.showWaypointText = !Waypoints.showWaypointText;
                            ConfigHandler.writeBooleanConfig("waypoint", "showWaypointText", Waypoints.showWaypointText);
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Show Waypoint Text has been set to: " + Waypoints.showWaypointText));
                            break block21;
                        }
                        case "boundingbox": 
                        case "waypointboundingbox": {
                            Waypoints.showBoundingBox = !Waypoints.showBoundingBox;
                            ConfigHandler.writeBooleanConfig("waypoint", "showBoundingBox", Waypoints.showBoundingBox);
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Show Waypoint Bounding Box has been set to: " + Waypoints.showBoundingBox));
                            break block21;
                        }
                        case "beacon": 
                        case "waypointbeacon": {
                            Waypoints.showBeacon = !Waypoints.showBeacon;
                            ConfigHandler.writeBooleanConfig("waypoint", "showBeacon", Waypoints.showBeacon);
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Show Waypoint Beacon has been set to: " + Waypoints.showBeacon));
                            break block21;
                        }
                        case "override": {
                            Utils.dungeonOverride = !Utils.dungeonOverride;
                            player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Force inCatacombs has been set to: " + Utils.dungeonOverride));
                            break block21;
                        }
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText(toggleHelp));
                    break;
                }
                case "reload": {
                    ConfigHandler.reloadConfig();
                    player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Reloaded config file"));
                    break;
                }
                case "discord": {
                    try {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Opening Dungeon Rooms Discord invite in browser..."));
                        Desktop.getDesktop().browse(new URI("https://discord.gg/7B5RbsArYK"));
                    }
                    catch (IOException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "relative": {
                    if (!RoomDetection.roomDirection.equals("undefined") && RoomDetection.roomCorner != null) {
                        if (mc.field_71476_x == null || mc.field_71476_x.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || mc.field_71476_x.func_178782_a() == null) break;
                        BlockPos relativePos = MapUtils.actualToRelative(mc.field_71476_x.func_178782_a(), RoomDetection.roomDirection, RoomDetection.roomCorner);
                        player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: You are looking at relative blockPos: " + relativePos));
                        break;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Unable to get relative blockPos at this time."));
                    break;
                }
                case "json": {
                    if (!Utils.inCatacombs && DungeonManager.gameStage != 2 && DungeonManager.gameStage != 3) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Use this command in dungeons"));
                        return;
                    }
                    if (DungeonRooms.roomsJson.get(RoomDetection.roomName) == null) break;
                    JsonObject json = DungeonRooms.roomsJson.get(RoomDetection.roomName).getAsJsonObject();
                    json.addProperty("name", RoomDetection.roomName);
                    player.func_145747_a((IChatComponent)new ChatComponentText(json.toString()));
                    break;
                }
                case "roominfo": {
                    if (!Utils.inCatacombs || DungeonManager.gameStage != 2) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Not in room clearing phase of dungeons"));
                    }
                    if (DungeonManager.entranceMapCorners != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("dev: entranceMapCorners = " + new ArrayList<Point>(Arrays.asList(DungeonManager.entranceMapCorners))));
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentText("dev: entranceMapCorners = null"));
                    }
                    if (DungeonManager.entrancePhysicalNWCorner != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("dev: entrancePhysicalNWCorner = " + DungeonManager.entrancePhysicalNWCorner));
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentText("dev: entrancePhysicalNWCorner = null"));
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: currentMapSegments = " + RoomDetection.currentMapSegments));
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: currentPhysicalSegments = " + RoomDetection.currentPhysicalSegments));
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: roomName = " + RoomDetection.roomName));
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: roomSize = " + RoomDetection.roomSize));
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: roomColor = " + RoomDetection.roomColor));
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: roomCategory = " + RoomDetection.roomCategory));
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: roomDirection = " + RoomDetection.roomDirection));
                    if (RoomDetection.roomCorner != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("dev: roomCorner = " + RoomDetection.roomCorner));
                        break;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText("dev: roomCorner = null"));
                    break;
                }
                case "blocksused": {
                    if (!Utils.inCatacombs || DungeonManager.gameStage != 2) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Not in room clearing phase of dungeons"));
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText(RoomDetection.blocksUsed.toString()));
                    break;
                }
                case "add": {
                    WorldClient world = mc.field_71441_e;
                    if (!Utils.inCatacombs || DungeonManager.gameStage != 2 || RoomDetection.roomDirection.equals("undefined") || RoomDetection.roomCorner == null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Current dungeon room is undefined"));
                        return;
                    }
                    switch (arg1[1].toLowerCase()) {
                        case "chest": {
                            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mc.field_71476_x.func_178782_a() != null) {
                                BlockPos viewingPos = MapUtils.actualToRelative(mc.field_71476_x.func_178782_a(), RoomDetection.roomDirection, RoomDetection.roomCorner);
                                if (world.func_180495_p(mc.field_71476_x.func_178782_a()).func_177230_c() == Blocks.field_150486_ae) {
                                    player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"# - Chest\",\n  \"category\":\"chest\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"));
                                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"# - Chest\",\n  \"category\":\"chest\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"), null);
                                    break block21;
                                }
                                player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at a Chest Secret"));
                                break block21;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at anything"));
                            break block21;
                        }
                        case "wither": {
                            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mc.field_71476_x.func_178782_a() != null) {
                                BlockPos viewingPos = MapUtils.actualToRelative(mc.field_71476_x.func_178782_a(), RoomDetection.roomDirection, RoomDetection.roomCorner);
                                if (world.func_180495_p(mc.field_71476_x.func_178782_a()).func_177230_c() == Blocks.field_150465_bP) {
                                    player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"# - Wither Essence\",\n  \"category\":\"wither\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"));
                                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"# - Wither Essence\",\n  \"category\":\"wither\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"), null);
                                    break block21;
                                }
                                player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at a Wither Essence Secret"));
                                break block21;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at anything"));
                            break block21;
                        }
                        case "superboom": {
                            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mc.field_71476_x.func_178782_a() != null) {
                                BlockPos viewingPos = MapUtils.actualToRelative(mc.field_71476_x.func_178782_a(), RoomDetection.roomDirection, RoomDetection.roomCorner);
                                if (world.func_180495_p(mc.field_71476_x.func_178782_a()).func_177230_c() == Blocks.field_150417_aV) {
                                    player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"# - Superboom\",\n  \"category\":\"superboom\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"));
                                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"# - Superboom\",\n  \"category\":\"superboom\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"), null);
                                    break block21;
                                }
                                player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at a Superboom entrance"));
                                break block21;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at anything"));
                            break block21;
                        }
                        case "lever": {
                            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mc.field_71476_x.func_178782_a() != null) {
                                BlockPos viewingPos = MapUtils.actualToRelative(mc.field_71476_x.func_178782_a(), RoomDetection.roomDirection, RoomDetection.roomCorner);
                                if (world.func_180495_p(mc.field_71476_x.func_178782_a()).func_177230_c() == Blocks.field_150442_at) {
                                    player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"# - Lever\",\n  \"category\":\"lever\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"));
                                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"# - Lever\",\n  \"category\":\"lever\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"), null);
                                    break block21;
                                }
                                player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at a Lever"));
                                break block21;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at anything"));
                            break block21;
                        }
                        case "fairysoul": {
                            if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mc.field_71476_x.func_178782_a() != null) {
                                BlockPos viewingPos = MapUtils.actualToRelative(mc.field_71476_x.func_178782_a().func_177981_b(1), RoomDetection.roomDirection, RoomDetection.roomCorner);
                                if (world.func_180495_p(mc.field_71476_x.func_178782_a().func_177981_b(1)).func_177230_c() == Blocks.field_150350_a) {
                                    player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"Fairy Soul\",\n  \"category\":\"fairysoul\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"));
                                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"Fairy Soul\",\n  \"category\":\"fairysoul\",\n  \"x\":" + viewingPos.func_177958_n() + ",\n  \"y\":" + viewingPos.func_177956_o() + ",\n  \"z\":" + viewingPos.func_177952_p() + "\n}"), null);
                                    break block21;
                                }
                                player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at the block below a Fairy Soul"));
                                break block21;
                            }
                            player.func_145747_a((IChatComponent)new ChatComponentText("You are not looking at anything"));
                            break block21;
                        }
                        case "item": {
                            BlockPos playerPos = MapUtils.actualToRelative(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), RoomDetection.roomDirection, RoomDetection.roomCorner);
                            player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"# - Item\",\n  \"category\":\"item\",\n  \"x\":" + playerPos.func_177958_n() + ",\n  \"y\":" + playerPos.func_177956_o() + ",\n  \"z\":" + playerPos.func_177952_p() + "\n}"));
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"# - Item\",\n  \"category\":\"item\",\n  \"x\":" + playerPos.func_177958_n() + ",\n  \"y\":" + playerPos.func_177956_o() + ",\n  \"z\":" + playerPos.func_177952_p() + "\n}"), null);
                            break block21;
                        }
                        case "entrance": {
                            BlockPos entrancePos = MapUtils.actualToRelative(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), RoomDetection.roomDirection, RoomDetection.roomCorner);
                            player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"# - Entrance\",\n  \"category\":\"entrance\",\n  \"x\":" + entrancePos.func_177958_n() + ",\n  \"y\":" + entrancePos.func_177956_o() + ",\n  \"z\":" + entrancePos.func_177952_p() + "\n}"));
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"# - Entrance\",\n  \"category\":\"entrance\",\n  \"x\":" + entrancePos.func_177958_n() + ",\n  \"y\":" + entrancePos.func_177956_o() + ",\n  \"z\":" + entrancePos.func_177952_p() + "\n}"), null);
                            break block21;
                        }
                        case "bat": {
                            BlockPos batPos = MapUtils.actualToRelative(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v), RoomDetection.roomDirection, RoomDetection.roomCorner);
                            player.func_145747_a((IChatComponent)new ChatComponentText("{\n  \"secretName\":\"# - Bat\",\n  \"category\":\"bat\",\n  \"x\":" + batPos.func_177958_n() + ",\n  \"y\":" + batPos.func_177956_o() + ",\n  \"z\":" + batPos.func_177952_p() + "\n}"));
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("{\n  \"secretName\":\"# - Bat\",\n  \"category\":\"bat\",\n  \"x\":" + batPos.func_177958_n() + ",\n  \"y\":" + batPos.func_177956_o() + ",\n  \"z\":" + batPos.func_177952_p() + "\n}"), null);
                            break block21;
                        }
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Valid options are <chest | wither | superboom | lever | fairysoul | item | entrance | bat | stonk>"));
                    break;
                }
                default: {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Run \"/room\" by itself to see the room name or run \"/room help\" for additional options"));
                }
            }
        }
    }
}

