/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.quantizr.dungeonrooms.commands.RoomCommand;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.DungeonManager;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.RoomDetection;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.Waypoints;
import io.github.quantizr.dungeonrooms.gui.WaypointsGUI;
import io.github.quantizr.dungeonrooms.handlers.ConfigHandler;
import io.github.quantizr.dungeonrooms.handlers.OpenLink;
import io.github.quantizr.dungeonrooms.handlers.PacketHandler;
import io.github.quantizr.dungeonrooms.handlers.TextRenderer;
import io.github.quantizr.dungeonrooms.utils.Utils;
import io.netty.channel.ChannelHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="dungeonrooms", version="3.4.1", acceptedMinecraftVersions="[1.8.9]")
public class DungeonRooms {
    public static final String MODID = "dungeonrooms";
    public static final String VERSION = "3.4.1";
    Minecraft mc = Minecraft.func_71410_x();
    public static Logger logger;
    public static JsonObject roomsJson;
    public static JsonObject waypointsJson;
    public static HashMap<String, HashMap<String, long[]>> ROOM_DATA;
    public static boolean usingSBPSecrets;
    public static KeyBinding[] keyBindings;
    public static String imageHotkeyOpen;
    static int tickAmount;
    public static List<String> textToDisplay;
    public static int textLocX;
    public static int textLocY;
    public static List<String> motd;
    public static String configDir;
    public static boolean firstLogin;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new RoomCommand());
        configDir = event.getModConfigurationDirectory().toString();
        logger = LogManager.getLogger(DungeonRooms.class);
        Utils.setLogLevel(LogManager.getLogger(DungeonRooms.class), Level.INFO);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        long time1 = System.currentTimeMillis();
        List<Path> paths = Utils.getAllPaths("catacombs");
        ExecutorService executor = Executors.newFixedThreadPool(4);
        Future<HashMap> future1x1 = executor.submit(() -> Utils.pathsToRoomData("1x1", paths));
        Future<HashMap> future1x2 = executor.submit(() -> Utils.pathsToRoomData("1x2", paths));
        Future<HashMap> future1x3 = executor.submit(() -> Utils.pathsToRoomData("1x3", paths));
        Future<HashMap> future1x4 = executor.submit(() -> Utils.pathsToRoomData("1x4", paths));
        Future<HashMap> future2x2 = executor.submit(() -> Utils.pathsToRoomData("2x2", paths));
        Future<HashMap> futureLShape = executor.submit(() -> Utils.pathsToRoomData("L-shape", paths));
        Future<HashMap> futurePuzzle = executor.submit(() -> Utils.pathsToRoomData("Puzzle", paths));
        Future<HashMap> futureTrap = executor.submit(() -> Utils.pathsToRoomData("Trap", paths));
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DungeonManager());
        MinecraftForge.EVENT_BUS.register((Object)new RoomDetection());
        MinecraftForge.EVENT_BUS.register((Object)new Waypoints());
        ConfigHandler.reloadConfig();
        DungeonRooms.keyBindings[0] = new KeyBinding("Open Room Images in DSG/SBP", 24, "Dungeon Rooms Mod");
        DungeonRooms.keyBindings[1] = new KeyBinding("Open Waypoint Config Menu", 25, "Dungeon Rooms Mod");
        DungeonRooms.keyBindings[2] = new KeyBinding("Show Waypoints in Practice Mode", 23, "Dungeon Rooms Mod");
        for (KeyBinding keyBinding : keyBindings) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        }
        try (BufferedReader roomsReader = new BufferedReader(new InputStreamReader(this.mc.func_110442_L().func_110536_a(new ResourceLocation(MODID, "dungeonrooms.json")).func_110527_b()));
             BufferedReader waypointsReader = new BufferedReader(new InputStreamReader(this.mc.func_110442_L().func_110536_a(new ResourceLocation(MODID, "secretlocations.json")).func_110527_b()));){
            Gson gson = new Gson();
            roomsJson = (JsonObject)gson.fromJson((Reader)roomsReader, JsonObject.class);
            logger.info("DungeonRooms: Loaded dungeonrooms.json");
            waypointsJson = (JsonObject)gson.fromJson((Reader)waypointsReader, JsonObject.class);
            logger.info("DungeonRooms: Loaded secretlocations.json");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            long time2 = System.currentTimeMillis();
            ROOM_DATA.put("1x1", future1x1.get());
            long time3 = System.currentTimeMillis();
            ROOM_DATA.put("1x2", future1x2.get());
            ROOM_DATA.put("1x3", future1x3.get());
            ROOM_DATA.put("1x4", future1x4.get());
            ROOM_DATA.put("2x2", future2x2.get());
            ROOM_DATA.put("L-shape", futureLShape.get());
            ROOM_DATA.put("Puzzle", futurePuzzle.get());
            ROOM_DATA.put("Trap", futureTrap.get());
            long time4 = System.currentTimeMillis();
            logger.debug("DungeonRooms: Time(ms) for init before get futures: " + (time2 - time1));
            logger.debug("DungeonRooms: Blocked Time(ms) for 1x1: " + (time3 - time2));
            logger.debug("DungeonRooms: Blocked Time(ms) remaining for other rooms: " + (time4 - time3));
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        executor.shutdown();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        usingSBPSecrets = Loader.isModLoaded((String)"sbp");
        logger.info("DungeonRooms: SBP Dungeon Secrets detection: " + usingSBPSecrets);
    }

    @SubscribeEvent
    public void onServerConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (this.mc.func_147104_D() == null) {
            return;
        }
        if (this.mc.func_147104_D().field_78845_b.toLowerCase().contains("hypixel.")) {
            logger.info("DungeonRooms: Connecting to Hypixel...");
            event.manager.channel().pipeline().addBefore("packet_handler", "drm_packet_handler", (ChannelHandler)new PacketHandler());
            logger.info("DungeonRooms: Packet Handler added");
            new Thread(() -> {
                try {
                    while (this.mc.field_71439_g == null) {
                        Thread.sleep(100L);
                    }
                    Thread.sleep(3000L);
                    if (this.mc.func_147104_D().field_78845_b.toLowerCase().contains("hypixel.")) {
                        String line;
                        logger.info("DungeonRooms: Checking for conflicting keybindings...");
                        Utils.checkForConflictingHotkeys();
                        logger.info("DungeonRooms: Checking for updates...");
                        URL url = new URL("https://api.github.com/repos/Quantizr/DungeonRoomsMod/releases/latest");
                        URLConnection request = url.openConnection();
                        request.connect();
                        JsonParser json = new JsonParser();
                        JsonObject latestRelease = json.parse((Reader)new InputStreamReader((InputStream)request.getContent())).getAsJsonObject();
                        String latestTag = latestRelease.get("tag_name").getAsString();
                        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(VERSION);
                        DefaultArtifactVersion latestVersion = new DefaultArtifactVersion(latestTag.substring(1));
                        if (currentVersion.compareTo((ArtifactVersion)latestVersion) < 0) {
                            String releaseURL = "https://github.com/Quantizr/DungeonRoomsMod/releases/latest";
                            ChatComponentText update = new ChatComponentText(EnumChatFormatting.GREEN + "" + EnumChatFormatting.BOLD + "  [UPDATE]  ");
                            update.func_150255_a(update.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, releaseURL)));
                            this.mc.field_71439_g.func_145747_a(new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms Mod is outdated. Please update to " + latestTag + ".\n").func_150257_a((IChatComponent)update));
                        } else {
                            logger.info("DungeonRooms: No update found");
                        }
                        logger.info("DungeonRooms: Getting MOTD...");
                        url = new URL("https://gist.githubusercontent.com/Quantizr/01aca53e61cef5dfd08989fec600b204/raw/");
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                        motd = new ArrayList<String>();
                        while ((line = in.readLine()) != null) {
                            motd.add(line);
                        }
                        in.close();
                        logger.info("DungeonRooms: MOTD has been checked");
                    }
                }
                catch (IOException | InterruptedException e) {
                    this.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: An error has occured. See logs for more details."));
                    e.printStackTrace();
                }
            }).start();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (++tickAmount % 20 == 0 && player != null) {
            Utils.checkForSkyblock();
            Utils.checkForCatacombs();
            tickAmount = 0;
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (keyBindings[0].func_151468_f()) {
            if (!Utils.inCatacombs) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Use this hotkey inside of a dungeon room"));
                return;
            }
            switch (imageHotkeyOpen) {
                case "gui": {
                    OpenLink.checkForLink("gui");
                    break;
                }
                case "dsg": {
                    OpenLink.checkForLink("dsg");
                    break;
                }
                case "sbp": {
                    OpenLink.checkForLink("sbp");
                    break;
                }
                default: {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: hotkeyOpen config value improperly set, do \"/room set <gui | dsg | sbp>\" to change the value"));
                }
            }
        }
        if (keyBindings[1].func_151468_f()) {
            this.mc.func_152344_a(() -> this.mc.func_147108_a((GuiScreen)new WaypointsGUI()));
        }
        if (keyBindings[2].func_151468_f()) {
            if (Waypoints.enabled && !Waypoints.practiceModeOn) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Run \"/room toggle practice\" to enable Practice Mode."));
            } else if (!Waypoints.enabled && Waypoints.practiceModeOn) {
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: Waypoints must be enabled for Practice Mode to work."));
            }
        }
    }

    @SubscribeEvent
    public void renderPlayerInfo(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (Utils.inSkyblock && textToDisplay != null && !textToDisplay.isEmpty()) {
            ScaledResolution scaledResolution = new ScaledResolution(this.mc);
            int y = 0;
            for (String line : textToDisplay) {
                int roomStringWidth = this.mc.field_71466_p.func_78256_a(line);
                TextRenderer.drawText(this.mc, line, scaledResolution.func_78326_a() * textLocX / 100 - roomStringWidth / 2, scaledResolution.func_78328_b() * textLocY / 100 + y, 1.0, true);
                y += this.mc.field_71466_p.field_78288_b;
            }
        }
    }

    static {
        ROOM_DATA = new HashMap();
        usingSBPSecrets = false;
        keyBindings = new KeyBinding[3];
        imageHotkeyOpen = "gui";
        tickAmount = 1;
        textToDisplay = null;
        textLocX = 50;
        textLocY = 5;
        motd = null;
        firstLogin = false;
    }
}

