/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.services;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.services.AnnotatedMethodService;
import org.incendo.cloud.services.annotation.ServiceImplementation;
import org.incendo.cloud.services.type.Service;

enum AnnotatedMethodServiceFactory {
    INSTANCE;


    @NonNull Map<? extends Service<?, ?>, TypeToken<? extends Service<?, ?>>> lookupServices(@NonNull Object instance) throws Exception {
        HashMap map2 = new HashMap();
        Class<?> clazz = instance.getClass();
        for (Method method2 : clazz.getDeclaredMethods()) {
            ServiceImplementation serviceImplementation = method2.getAnnotation(ServiceImplementation.class);
            if (serviceImplementation == null) continue;
            if (method2.getParameterCount() != 1) {
                throw new IllegalArgumentException(String.format("Method '%s' in class '%s' has wrong parameter count. Expected 1, got %d", method2.getName(), instance.getClass().getCanonicalName(), method2.getParameterCount()));
            }
            map2.put(new AnnotatedMethodService(instance, method2), TypeToken.get(serviceImplementation.value()));
        }
        return map2;
    }
}

