/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import org.commonmark.internal.ListItemParser;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.BulletList;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.OrderedList;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

public class ListBlockParser
extends AbstractBlockParser {
    private final ListBlock block;
    private boolean hadBlankLine;
    private int linesAfterBlank;

    public ListBlockParser(ListBlock block2) {
        this.block = block2;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block childBlock) {
        if (childBlock instanceof ListItem) {
            if (this.hadBlankLine && this.linesAfterBlank == 1) {
                this.block.setTight(false);
                this.hadBlankLine = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.isBlank()) {
            this.hadBlankLine = true;
            this.linesAfterBlank = 0;
        } else if (this.hadBlankLine) {
            ++this.linesAfterBlank;
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    private static ListData parseList(CharSequence line, int markerIndex, int markerColumn, boolean inParagraph) {
        int columnAfterMarker;
        ListMarkerData listMarker = ListBlockParser.parseListMarker(line, markerIndex);
        if (listMarker == null) {
            return null;
        }
        ListBlock listBlock = listMarker.listBlock;
        int indexAfterMarker = listMarker.indexAfterMarker;
        int markerLength = indexAfterMarker - markerIndex;
        int contentColumn = columnAfterMarker = markerColumn + markerLength;
        boolean hasContent = false;
        int length = line.length();
        for (int i2 = indexAfterMarker; i2 < length; ++i2) {
            char c = line.charAt(i2);
            if (c == '\t') {
                contentColumn += Parsing.columnsToNextTabStop(contentColumn);
                continue;
            }
            if (c == ' ') {
                ++contentColumn;
                continue;
            }
            hasContent = true;
            break;
        }
        if (inParagraph) {
            if (listBlock instanceof OrderedList && ((OrderedList)listBlock).getStartNumber() != 1) {
                return null;
            }
            if (!hasContent) {
                return null;
            }
        }
        if (!hasContent || contentColumn - columnAfterMarker > Parsing.CODE_BLOCK_INDENT) {
            contentColumn = columnAfterMarker + 1;
        }
        return new ListData(listBlock, contentColumn);
    }

    private static ListMarkerData parseListMarker(CharSequence line, int index) {
        char c = line.charAt(index);
        switch (c) {
            case '*': 
            case '+': 
            case '-': {
                if (ListBlockParser.isSpaceTabOrEnd(line, index + 1)) {
                    BulletList bulletList = new BulletList();
                    bulletList.setBulletMarker(c);
                    return new ListMarkerData(bulletList, index + 1);
                }
                return null;
            }
        }
        return ListBlockParser.parseOrderedList(line, index);
    }

    private static ListMarkerData parseOrderedList(CharSequence line, int index) {
        int digits = 0;
        int length = line.length();
        block4: for (int i2 = index; i2 < length; ++i2) {
            char c = line.charAt(i2);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (++digits <= 9) continue block4;
                    return null;
                }
                case ')': 
                case '.': {
                    if (digits >= 1 && ListBlockParser.isSpaceTabOrEnd(line, i2 + 1)) {
                        String number = line.subSequence(index, i2).toString();
                        OrderedList orderedList = new OrderedList();
                        orderedList.setStartNumber(Integer.parseInt(number));
                        orderedList.setDelimiter(c);
                        return new ListMarkerData(orderedList, i2 + 1);
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static boolean isSpaceTabOrEnd(CharSequence line, int index) {
        if (index < line.length()) {
            switch (line.charAt(index)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean listsMatch(ListBlock a, ListBlock b) {
        if (a instanceof BulletList && b instanceof BulletList) {
            return ListBlockParser.equals(Character.valueOf(((BulletList)a).getBulletMarker()), Character.valueOf(((BulletList)b).getBulletMarker()));
        }
        if (a instanceof OrderedList && b instanceof OrderedList) {
            return ListBlockParser.equals(Character.valueOf(((OrderedList)a).getDelimiter()), Character.valueOf(((OrderedList)b).getDelimiter()));
        }
        return false;
    }

    private static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static class ListMarkerData {
        final ListBlock listBlock;
        final int indexAfterMarker;

        ListMarkerData(ListBlock listBlock, int indexAfterMarker) {
            this.listBlock = listBlock;
            this.indexAfterMarker = indexAfterMarker;
        }
    }

    private static class ListData {
        final ListBlock listBlock;
        final int contentColumn;

        ListData(ListBlock listBlock, int contentColumn) {
            this.listBlock = listBlock;
            this.contentColumn = contentColumn;
        }
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BlockParser matched2 = matchedBlockParser.getMatchedBlockParser();
            if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int markerIndex = state.getNextNonSpaceIndex();
            int markerColumn = state.getColumn() + state.getIndent();
            boolean inParagraph = !matchedBlockParser.getParagraphLines().isEmpty();
            ListData listData = ListBlockParser.parseList(state.getLine().getContent(), markerIndex, markerColumn, inParagraph);
            if (listData == null) {
                return BlockStart.none();
            }
            int newColumn = listData.contentColumn;
            ListItemParser listItemParser = new ListItemParser(newColumn - state.getColumn());
            if (!(matched2 instanceof ListBlockParser) || !ListBlockParser.listsMatch((ListBlock)matched2.getBlock(), listData.listBlock)) {
                ListBlockParser listBlockParser = new ListBlockParser(listData.listBlock);
                listData.listBlock.setTight(true);
                return BlockStart.of(listBlockParser, listItemParser).atColumn(newColumn);
            }
            return BlockStart.of(listItemParser).atColumn(newColumn);
        }
    }
}

