/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

final class Huffman {
    static final int HUFFMAN_MAX_TABLE_SIZE = 1080;
    private static final int MAX_LENGTH = 15;

    Huffman() {
    }

    private static int getNextKey(int key2, int len) {
        int step = 1 << len - 1;
        while ((key2 & step) != 0) {
            step >>= 1;
        }
        return (key2 & step - 1) + step;
    }

    private static void replicateValue(int[] table, int offset, int step, int end2, int item) {
        do {
            table[offset + (end2 -= step)] = item;
        } while (end2 > 0);
    }

    private static int nextTableBitSize(int[] count2, int len, int rootBits) {
        int left = 1 << len - rootBits;
        while (len < 15 && (left -= count2[len]) > 0) {
            ++len;
            left <<= 1;
        }
        return len - rootBits;
    }

    static void buildHuffmanTable(int[] rootTable, int tableOffset, int rootBits, int[] codeLengths, int codeLengthsSize) {
        int tableSize;
        int symbol;
        int[] sorted2 = new int[codeLengthsSize];
        int[] count2 = new int[16];
        int[] offset = new int[16];
        for (symbol = 0; symbol < codeLengthsSize; ++symbol) {
            int n = codeLengths[symbol];
            count2[n] = count2[n] + 1;
        }
        offset[1] = 0;
        for (int len = 1; len < 15; ++len) {
            offset[len + 1] = offset[len] + count2[len];
        }
        for (symbol = 0; symbol < codeLengthsSize; ++symbol) {
            if (codeLengths[symbol] == 0) continue;
            int n = codeLengths[symbol];
            int n2 = offset[n];
            offset[n] = n2 + 1;
            sorted2[n2] = symbol;
        }
        int tableBits = rootBits;
        int totalSize = tableSize = 1 << tableBits;
        if (offset[15] == 1) {
            for (int key2 = 0; key2 < totalSize; ++key2) {
                rootTable[tableOffset + key2] = sorted2[0];
            }
            return;
        }
        int key3 = 0;
        symbol = 0;
        int len = 1;
        int step = 2;
        while (len <= rootBits) {
            while (count2[len] > 0) {
                Huffman.replicateValue(rootTable, tableOffset + key3, step, tableSize, len << 16 | sorted2[symbol++]);
                key3 = Huffman.getNextKey(key3, len);
                int n = len;
                count2[n] = count2[n] - 1;
            }
            ++len;
            step <<= 1;
        }
        int mask = totalSize - 1;
        int low = -1;
        int currentOffset = tableOffset;
        int len2 = rootBits + 1;
        int step2 = 2;
        while (len2 <= 15) {
            while (count2[len2] > 0) {
                if ((key3 & mask) != low) {
                    tableBits = Huffman.nextTableBitSize(count2, len2, rootBits);
                    tableSize = 1 << tableBits;
                    totalSize += tableSize;
                    low = key3 & mask;
                    rootTable[tableOffset + low] = tableBits + rootBits << 16 | (currentOffset += tableSize) - tableOffset - low;
                }
                Huffman.replicateValue(rootTable, currentOffset + (key3 >> rootBits), step2, tableSize, len2 - rootBits << 16 | sorted2[symbol++]);
                key3 = Huffman.getNextKey(key3, len2);
                int n = len2;
                count2[n] = count2[n] - 1;
            }
            ++len2;
            step2 <<= 1;
        }
    }
}

