/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.util.io.Streams;

public class PBEFileProcessor {
    private static void decryptFile(String string, char[] cArray) throws IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PBEFileProcessor.decryptFile(bufferedInputStream, cArray);
        ((InputStream)bufferedInputStream).close();
    }

    private static void decryptFile(InputStream inputStream2, char[] cArray) throws IOException, PGPException {
        Object object;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream2 = PGPUtil.getDecoderStream(inputStream2));
        Object object2 = jcaPGPObjectFactory.nextObject();
        PGPEncryptedDataList pGPEncryptedDataList = object2 instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object2 : (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        if (!pGPPBEEncryptedData.isIntegrityProtected()) {
            throw new PGPException("Message is not integrity protected!");
        }
        JcePBEDataDecryptorFactoryBuilder jcePBEDataDecryptorFactoryBuilder = new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC");
        InputStream inputStream3 = pGPPBEEncryptedData.getDataStream(jcePBEDataDecryptorFactoryBuilder.build(cArray));
        jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream3);
        object2 = jcaPGPObjectFactory.nextObject();
        if (object2 instanceof PGPCompressedData) {
            object = (PGPCompressedData)object2;
            jcaPGPObjectFactory = new JcaPGPObjectFactory(((PGPCompressedData)object).getDataStream());
            object2 = jcaPGPObjectFactory.nextObject();
        }
        object = (PGPLiteralData)object2;
        InputStream inputStream4 = ((PGPLiteralData)object).getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(((PGPLiteralData)object).getFileName());
        Streams.pipeAll((InputStream)inputStream4, (OutputStream)fileOutputStream, (int)8192);
        ((OutputStream)fileOutputStream).close();
        if (!pGPPBEEncryptedData.verify()) {
            System.err.println("message failed integrity check");
        } else {
            System.err.println("message integrity check passed");
        }
    }

    private static void encryptFile(String string, String string2, char[] cArray, boolean bl) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        PBEFileProcessor.encryptToStream(bufferedOutputStream, string2, cArray, bl);
        ((OutputStream)bufferedOutputStream).close();
    }

    private static void encryptToStream(OutputStream outputStream2, String string, char[] cArray, boolean bl) throws IOException {
        block4: {
            if (bl) {
                outputStream2 = new ArmoredOutputStream(outputStream2);
            }
            File file2 = new File(string);
            try {
                JcePGPDataEncryptorBuilder jcePGPDataEncryptorBuilder = new JcePGPDataEncryptorBuilder(9).setProvider("BC").setSecureRandom(new SecureRandom()).setWithIntegrityPacket(true);
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(jcePGPDataEncryptorBuilder);
                pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(cArray).setProvider("BC"));
                OutputStream outputStream3 = pGPEncryptedDataGenerator.open(outputStream2, new byte[8192]);
                PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
                OutputStream outputStream4 = pGPCompressedDataGenerator.open(outputStream3);
                PGPUtil.writeFileToLiteralData(outputStream4, 'b', file2);
                outputStream4.flush();
                outputStream4.close();
                outputStream3.flush();
                outputStream3.close();
                if (bl) {
                    outputStream2.flush();
                    outputStream2.close();
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block4;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a")) {
                PBEFileProcessor.encryptFile(stringArray[2] + ".asc", stringArray[2], stringArray[3].toCharArray(), true);
            } else {
                PBEFileProcessor.encryptFile(stringArray[1] + ".bpg", stringArray[1], stringArray[2].toCharArray(), false);
            }
        } else if (stringArray[0].equals("-d")) {
            PBEFileProcessor.decryptFile(stringArray[1], stringArray[2].toCharArray());
        } else {
            System.err.println("usage: PBEFileProcessor -e [-a]|-d file passPhrase");
        }
    }
}

