/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;

class StreamUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();

    StreamUtil() {
    }

    static int findLimit(InputStream inputStream2) {
        if (inputStream2 instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)inputStream2).available();
        }
        if (inputStream2 instanceof FileInputStream) {
            try {
                long l;
                FileChannel fileChannel = ((FileInputStream)inputStream2).getChannel();
                long l2 = l = fileChannel != null ? fileChannel.size() : Integer.MAX_VALUE;
                if (l < Integer.MAX_VALUE) {
                    return (int)l;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    static void writeNewPacketLength(OutputStream outputStream2, long l) throws IOException {
        if (l < 192L) {
            outputStream2.write((byte)l);
        } else if (l <= 8383L) {
            outputStream2.write((byte)(((l -= 192L) >> 8 & 0xFFL) + 192L));
            outputStream2.write((byte)l);
        } else {
            outputStream2.write(255);
            StreamUtil.writeBodyLen(outputStream2, l);
        }
    }

    static void writeBodyLen(OutputStream outputStream2, long l) throws IOException {
        outputStream2.write((byte)(l >> 24));
        outputStream2.write((byte)(l >> 16));
        outputStream2.write((byte)(l >> 8));
        outputStream2.write((byte)l);
    }

    static void writeKeyID(BCPGOutputStream bCPGOutputStream, long l) throws IOException {
        bCPGOutputStream.write((byte)(l >> 56));
        bCPGOutputStream.write((byte)(l >> 48));
        bCPGOutputStream.write((byte)(l >> 40));
        bCPGOutputStream.write((byte)(l >> 32));
        bCPGOutputStream.write((byte)(l >> 24));
        bCPGOutputStream.write((byte)(l >> 16));
        bCPGOutputStream.write((byte)(l >> 8));
        bCPGOutputStream.write((byte)l);
    }

    static long readKeyID(BCPGInputStream bCPGInputStream) throws IOException {
        long l = (long)bCPGInputStream.read() << 56;
        l |= (long)bCPGInputStream.read() << 48;
        l |= (long)bCPGInputStream.read() << 40;
        l |= (long)bCPGInputStream.read() << 32;
        l |= (long)bCPGInputStream.read() << 24;
        l |= (long)bCPGInputStream.read() << 16;
        return (l |= (long)bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
    }

    static void writeTime(BCPGOutputStream bCPGOutputStream, long l) throws IOException {
        bCPGOutputStream.write((byte)(l >> 24));
        bCPGOutputStream.write((byte)(l >> 16));
        bCPGOutputStream.write((byte)(l >> 8));
        bCPGOutputStream.write((byte)l);
    }
}

