/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.gui.common.shadow;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.effects.Effect;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.MappedState;
import gg.essential.elementa.state.State;
import gg.essential.universal.UMatrixStack;
import gg.skytils.vigilance.gui.VigilancePalette;
import gg.skytils.vigilance.gui.common.shadow.ShadowEffect;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\r\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lgg/skytils/vigilance/gui/common/shadow/ShadowEffect;", "Lgg/essential/elementa/effects/Effect;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "beforeDraw", "(Lgg/essential/universal/UMatrixStack;)V", "", "getDebugInfo", "()Ljava/lang/String;", "Lgg/essential/elementa/state/State;", "Ljava/awt/Color;", "state", "rebindColor", "(Lgg/essential/elementa/state/State;)Lgg/essential/vigilance/gui/common/shadow/ShadowEffect;", "Lgg/essential/elementa/state/MappedState;", "shadowColorState", "Lgg/essential/elementa/state/MappedState;", "shadowColor", "<init>", "(Ljava/awt/Color;)V", "Vigilance"})
public final class ShadowEffect
extends Effect {
    @NotNull
    private final MappedState<Color, Color> shadowColorState;

    public ShadowEffect(@NotNull Color shadowColor) {
        Intrinsics.checkNotNullParameter((Object)shadowColor, (String)"shadowColor");
        this.shadowColorState = new BasicState((Object)shadowColor).map((Function1)shadowColorState.1.INSTANCE);
    }

    public /* synthetic */ ShadowEffect(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color = VigilancePalette.INSTANCE.getComponentBackground();
        }
        this(color);
    }

    public void beforeDraw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        UIComponent boundComponent = this.getBoundComponent();
        if (boundComponent instanceof UIBlock) {
            if (boundComponent.getColor().getAlpha() == 0) {
                return;
            }
            double x = boundComponent.getLeft();
            double y = boundComponent.getTop();
            double x2 = boundComponent.getRight();
            double y2 = boundComponent.getBottom();
            Color color = (Color)this.shadowColorState.get();
            UIBlock.Companion.drawBlock(matrixStack, color, x + 1.0, y + 1.0, x2 + 1.0, y2 + 1.0);
        } else if (boundComponent instanceof UIImage) {
            ((UIImage)boundComponent).drawImage(matrixStack, (double)boundComponent.getLeft() + 1.0, (double)boundComponent.getTop() + 1.0, (double)boundComponent.getWidth(), (double)boundComponent.getHeight(), (Color)this.shadowColorState.get());
        } else {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Shadow effect cannot be applied to ", (Object)this.getDebugInfo()));
        }
    }

    @NotNull
    public final ShadowEffect rebindColor(@NotNull State<Color> state) {
        ShadowEffect shadowEffect;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        ShadowEffect $this$rebindColor_u24lambda_u2d0 = shadowEffect = this;
        boolean bl = false;
        $this$rebindColor_u24lambda_u2d0.shadowColorState.rebind(state);
        return shadowEffect;
    }

    private final String getDebugInfo() {
        return this.getBoundComponent().getComponentName() + ' ' + this.getBoundComponent().getClass().getName();
    }

    public ShadowEffect() {
        this(null, 1, null);
    }
}

