/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u0004*\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u0011\u0010\u0011\u001a\u00020\u0007*\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0015\u001a\u00020\u0013*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0015\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0018J\u0011\u0010\u0019\u001a\u00020\u0004*\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR0\u0010 \u001a\u001e\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00040\u00040\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010!\u00a8\u0006%"}, d2={"Lgg/skytils/skytilsmod/utils/NumberUtil;", "", "", "value", "", "format", "(Ljava/lang/Number;)Ljava/lang/String;", "", "decimal", "lastNumber", "lastDecimal", "processDecimal", "(III)I", "", "unformat", "(Ljava/lang/String;)J", "addSuffix", "romanToDecimal", "(Ljava/lang/String;)I", "", "precision", "roundToPrecision", "(DI)D", "", "(FI)F", "toRoman", "(I)Ljava/lang/String;", "Ljava/text/NumberFormat;", "nf", "Ljava/text/NumberFormat;", "Ljava/util/TreeMap;", "kotlin.jvm.PlatformType", "romanSymbols", "Ljava/util/TreeMap;", "suffixes", "<init>", "()V", "SkytilsMod"})
@SourceDebugExtension(value={"SMAP\nNumberUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberUtil.kt\ngg/skytils/skytilsmod/utils/NumberUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n429#2:170\n502#2,5:171\n429#2:176\n502#2,5:177\n1#3:182\n*S KotlinDebug\n*F\n+ 1 NumberUtil.kt\ngg/skytils/skytilsmod/utils/NumberUtil\n*L\n75#1:170\n75#1:171,5\n76#1:176\n76#1:177,5\n*E\n"})
public final class NumberUtil {
    @NotNull
    public static final NumberUtil INSTANCE;
    @JvmField
    @NotNull
    public static final NumberFormat nf;
    @NotNull
    private static final TreeMap<Long, String> suffixes;
    @NotNull
    private static final TreeMap<Integer, String> romanSymbols;

    private NumberUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String format(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        long value2 = value.longValue();
        if (value2 == Long.MIN_VALUE) {
            return NumberUtil.format(-9223372036854775807L);
        }
        if (value2 < 0L) {
            return '-' + NumberUtil.format(-value2);
        }
        if (value2 < 1000L) {
            return String.valueOf(value2);
        }
        Map.Entry<Long, String> entry = suffixes.floorEntry(value2);
        Intrinsics.checkNotNull(entry);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = value2 / (divideBy / (long)10);
        boolean hasDecimal = truncated < 100L && !((double)truncated / 10.0 == (double)(truncated / (long)10));
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / (long)10 + suffix;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final long unformat(@NotNull String value) {
        Object object;
        Object var16_22;
        long l;
        block4: {
            Object v7;
            void $this$filterTo$iv$iv;
            int it;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String $this$filter$iv = value;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo22 = false;
            int n = $this$filterTo$iv$iv2.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                int element$iv$iv;
                it = element$iv$iv = $this$filterTo$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = !Character.isDigit((char)it);
                if (!bl2) continue;
                destination$iv$iv.append((char)element$iv$iv);
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String suffix = string2;
            String $this$filter$iv2 = value;
            boolean $i$f$filter2 = false;
            CharSequence $i$f$filterTo22 = $this$filter$iv2;
            Appendable destination$iv$iv2 = new StringBuilder();
            boolean $i$f$filterTo = false;
            it = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < it; ++index$iv$iv) {
                char element$iv$iv;
                char it2 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!Character.isDigit(it2)) continue;
                destination$iv$iv2.append(element$iv$iv);
            }
            String string3 = ((StringBuilder)destination$iv$iv2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            long num = Long.parseLong(string3);
            Set<Map.Entry<Long, String>> set2 = suffixes.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
            Iterable iterable = set2;
            l = num;
            Iterable iterable2 = iterable;
            for (Object t2 : iterable2) {
                Map.Entry it3 = (Map.Entry)t2;
                boolean bl = false;
                Object v = it3.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                String string4 = ((String)v).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string4, (Object)suffix)) continue;
                v7 = t2;
                break block4;
            }
            v7 = var16_22 = null;
        }
        if ((object = (Map.Entry)var16_22) == null || (object = (Long)object.getKey()) == null) {
            object = 1L;
        }
        return l * ((Number)object).longValue();
    }

    public final double roundToPrecision(double $this$roundToPrecision, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)MathKt.roundToInt((double)($this$roundToPrecision * (double)scale)) / (double)scale;
    }

    public final float roundToPrecision(float $this$roundToPrecision, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (float)MathKt.roundToInt((float)($this$roundToPrecision * (float)scale)) / (float)scale;
    }

    @NotNull
    public final String addSuffix(@NotNull Number $this$addSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$addSuffix, (String)"<this>");
        long l = $this$addSuffix.longValue();
        boolean bl = 11L <= l ? l < 14L : false;
        if (bl) {
            return $this$addSuffix + "th";
        }
        long l2 = l % (long)10;
        return l2 == 1L ? $this$addSuffix + "st" : (l2 == 2L ? $this$addSuffix + "nd" : (l2 == 3L ? $this$addSuffix + "rd" : $this$addSuffix + "th"));
    }

    public final int romanToDecimal(@NotNull String $this$romanToDecimal) {
        Intrinsics.checkNotNullParameter((Object)$this$romanToDecimal, (String)"<this>");
        int decimal = 0;
        int lastNumber = 0;
        String string = $this$romanToDecimal.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String romanNumeral = string;
        for (int x = romanNumeral.length() - 1; -1 < x; --x) {
            char c = romanNumeral.charAt(x);
            if (c == 'M') {
                decimal = this.processDecimal(1000, lastNumber, decimal);
                lastNumber = 1000;
                continue;
            }
            if (c == 'D') {
                decimal = this.processDecimal(500, lastNumber, decimal);
                lastNumber = 500;
                continue;
            }
            if (c == 'C') {
                decimal = this.processDecimal(100, lastNumber, decimal);
                lastNumber = 100;
                continue;
            }
            if (c == 'L') {
                decimal = this.processDecimal(50, lastNumber, decimal);
                lastNumber = 50;
                continue;
            }
            if (c == 'X') {
                decimal = this.processDecimal(10, lastNumber, decimal);
                lastNumber = 10;
                continue;
            }
            if (c == 'V') {
                decimal = this.processDecimal(5, lastNumber, decimal);
                lastNumber = 5;
                continue;
            }
            if (c != 'I') continue;
            decimal = this.processDecimal(1, lastNumber, decimal);
            lastNumber = 1;
        }
        return decimal;
    }

    @NotNull
    public final String toRoman(int $this$toRoman) {
        String string;
        if ($this$toRoman <= 0) {
            throw new IllegalStateException(($this$toRoman + " must be positive!").toString());
        }
        Integer l = romanSymbols.floorKey($this$toRoman);
        Integer n = l;
        if (n != null && $this$toRoman == n) {
            String string2 = romanSymbols.get($this$toRoman);
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string2;
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(romanSymbols.get(l));
            Intrinsics.checkNotNull((Object)l);
            string = stringBuilder.append(this.toRoman($this$toRoman - l)).toString();
        }
        return string;
    }

    private final int processDecimal(int decimal, int lastNumber, int lastDecimal) {
        return lastNumber > decimal ? lastDecimal - decimal : lastDecimal + decimal;
    }

    static {
        Pair[] pairArray;
        INSTANCE = new NumberUtil();
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"getInstance(...)");
        nf = numberFormat;
        Pair[] $this$suffixes_u24lambda_u240 = pairArray = new TreeMap();
        boolean bl = false;
        ((Map)$this$suffixes_u24lambda_u240).put(1000L, "k");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000L, "M");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000L, "B");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000L, "T");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000000L, "P");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000000000L, "E");
        suffixes = pairArray;
        pairArray = new Pair[]{TuplesKt.to((Object)1000, (Object)"M"), TuplesKt.to((Object)900, (Object)"CM"), TuplesKt.to((Object)500, (Object)"D"), TuplesKt.to((Object)400, (Object)"CD"), TuplesKt.to((Object)100, (Object)"C"), TuplesKt.to((Object)90, (Object)"XC"), TuplesKt.to((Object)50, (Object)"L"), TuplesKt.to((Object)40, (Object)"XL"), TuplesKt.to((Object)10, (Object)"X"), TuplesKt.to((Object)9, (Object)"IX"), TuplesKt.to((Object)5, (Object)"V"), TuplesKt.to((Object)4, (Object)"IV"), TuplesKt.to((Object)1, (Object)"I")};
        romanSymbols = new TreeMap(MapsKt.mapOf((Pair[])pairArray));
    }
}

