/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.http.HttpHeaders;
import gg.skytils.ktor.server.application.ApplicationCall;
import gg.skytils.ktor.server.response.ApplicationResponsePropertiesKt;
import gg.skytils.ktor.server.sessions.SessionTransport;
import gg.skytils.ktor.server.sessions.SessionTransportTransformer;
import gg.skytils.ktor.server.sessions.SessionTransportTransformerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u000eR\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lgg/skytils/ktor/server/sessions/SessionTransportHeader;", "Lgg/skytils/ktor/server/sessions/SessionTransport;", "Lgg/skytils/ktor/server/application/ApplicationCall;", "call", "", "clear", "(Lgg/skytils/ktor/server/application/ApplicationCall;)V", "", "receive", "(Lgg/skytils/ktor/server/application/ApplicationCall;)Ljava/lang/String;", "value", "send", "(Lgg/skytils/ktor/server/application/ApplicationCall;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "name", "Ljava/lang/String;", "getName", "", "Lgg/skytils/ktor/server/sessions/SessionTransportTransformer;", "transformers", "Ljava/util/List;", "getTransformers", "()Ljava/util/List;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "ktor-server-sessions"})
public final class SessionTransportHeader
implements SessionTransport {
    @NotNull
    private final String name;
    @NotNull
    private final List<SessionTransportTransformer> transformers;

    public SessionTransportHeader(@NotNull String name, @NotNull List<? extends SessionTransportTransformer> transformers) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(transformers, (String)"transformers");
        this.name = name;
        this.transformers = transformers;
        HttpHeaders.INSTANCE.checkHeaderName(this.name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<SessionTransportTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    @Nullable
    public String receive(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return SessionTransportTransformerKt.transformRead(this.transformers, call.getRequest().getHeaders().get(this.name));
    }

    @Override
    public void send(@NotNull ApplicationCall call, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ApplicationResponsePropertiesKt.header(call.getResponse(), this.name, SessionTransportTransformerKt.transformWrite(this.transformers, value));
    }

    @Override
    public void clear(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
    }

    @NotNull
    public String toString() {
        return "SessionTransportHeader: " + this.name;
    }
}

