/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j.encoder;

import com.aayushatharva.brotli4j.encoder.Encoder;
import com.aayushatharva.brotli4j.encoder.EncoderJNI;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class Encoders {
    public static ByteBuf compress(ByteBuf src, boolean pooled) throws IOException {
        ByteBuf dst = pooled ? PooledByteBufAllocator.DEFAULT.directBuffer() : Unpooled.directBuffer();
        Encoders.compress(src, dst);
        return dst;
    }

    public static void compress(ByteBuf src, ByteBuf dst) throws IOException {
        Encoders.compress(src, dst, Encoder.Parameters.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(ByteBuffer src, ByteBuffer dst) throws IOException {
        ByteBuf srcBuf = PooledByteBufAllocator.DEFAULT.directBuffer();
        ByteBuf dstBuf = PooledByteBufAllocator.DEFAULT.directBuffer();
        try {
            srcBuf.writeBytes(src);
            Encoders.compress(srcBuf, dstBuf, Encoder.Parameters.DEFAULT);
        }
        finally {
            dst.put(dstBuf.nioBuffer());
            srcBuf.release();
            dstBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(ByteBuffer src, ByteBuffer dst, Encoder.Parameters params) throws IOException {
        ByteBuf srcBuf = PooledByteBufAllocator.DEFAULT.directBuffer();
        ByteBuf dstBuf = PooledByteBufAllocator.DEFAULT.directBuffer();
        try {
            srcBuf.writeBytes(src);
            Encoders.compress(srcBuf, dstBuf, params);
        }
        finally {
            dst.put(dstBuf.nioBuffer());
            srcBuf.release();
            dstBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(ByteBuf src, ByteBuf dst, Encoder.Parameters params) throws IOException {
        int readableBytes = src.readableBytes();
        if (readableBytes == 0) {
            dst.writeByte(6);
            return;
        }
        EncoderJNI.Wrapper encoder2 = new EncoderJNI.Wrapper(readableBytes, params.quality(), params.lgwin(), params.mode());
        try {
            encoder2.getInputBuffer().put(src.nioBuffer());
            encoder2.push(EncoderJNI.Operation.PROCESS, readableBytes);
            while (true) {
                if (!encoder2.isSuccess()) {
                    throw new IOException("encoding failed");
                }
                if (encoder2.hasMoreOutput()) {
                    ByteBuffer buffer = encoder2.pull();
                    dst.writeBytes(buffer);
                    continue;
                }
                if (!encoder2.isFinished()) {
                    encoder2.push(EncoderJNI.Operation.FINISH, 0);
                    continue;
                }
                break;
            }
        }
        finally {
            encoder2.destroy();
        }
    }
}

